/**----------------------------------------------------------------------------------*/
void dumpFastModeInfo()
{
  Serial.println(F(" fast mode help ..."));
  Serial.print(F("   StartFrequency: "));
  Serial.print(startF);
  Serial.print(F(" / Channel Spacing "));
  Serial.print(stepF);
  Serial.println(F(" (kHz)"));
  Serial.println(" ");
  Serial.println("Program radio on channel nr 4 by command: p 04.");
}

void drawLine(void)
{
  int i;
  for (i = 0 ; i < 3 ; i++)
    Serial.print(F("----------"));
  Serial.println("");
}

/**----------------------------------------------------------------------------------*/
void dmpProgID()
{
  int i;
  delay(500);
  for (i = 0 ; i < 3 ; i++)
    Serial.println(" ");
  Serial.print(F("APC220 radio reprogramming -  version: "));
  Serial.print(vrs);
  Serial.print(F(" - compiled "));
  Serial.println(__DATE__);
  Serial.println(F(" (C) Jens Dalsgaard Nielsen - http://es.aau.dk/staff/jdn - AAU (GPL 2)"));
  drawLine();
}

void setupHlp()
{
  Serial.println(F("      FFFFFF: frequency: 434000 (434 MHz default ) range approx 418000-4/5000  "));
  Serial.println(F("      R:      Rf data rate       - 1/2/3/4 equals 2400(1km)/4800/9600/19200bps"));
  Serial.println(F("      P:      Radio output power - 0 .. 9 9 equals 13dBm(20mW)."));
  Serial.println(F("      B:      UART baudrate      - 0/1/2/3/4/5/6 equals 1200/2400/4800/9600/19200/38400/57600bps"));
  Serial.println(F("      C:      Byte Chek Parity   - 0/1/2 equals NoCheck(8N1)/EvenParity(8E1)/OddParity(8O1)"));
  Serial.println(F(""));
  Serial.println(F("Write example: w 434000 3 9 3 0 is..."));
  Serial.println(F("    434,000 MHz 9600 baud in air, 20mW, 9600baud on UART, No Parity(8N1)"));
}
/**----------------------------------------------------------------------------------*/
void menu(void)
{
  Serial.println(" ");
  Serial.println(F("COMMANDS:"));
  Serial.println(F("  v :  Help for dump config for fast mode"));
  Serial.println(F("  c :  Clear Screen"));
  Serial.println(F("  r :  Read apc220 radio config"));
  Serial.println(F("  R :  reset program"));
  Serial.println(F("  b :  start beacon mode"));

  Serial.println(F("  p xx :  Fast program  - program channel xx relative to config try 'v' for help "));
  Serial.println(F("  w  FFFFFF R P B C - number of letters indicates precise number of digits" ));
  setupHlp();
  Serial.println(F("\nENTER COMMAND: "));
}

/**----------------------------------------------------------------------------------*/
void smallHelpMenu(void)
{
  Serial.println(F("   commands: r  -or-  w (434000 3 9 3 0)  -or-  p 01 (00-99)  -or-  h (help)/ c (clear screen)"));
}

