/****************************************************
 * APC220 config
 * A small arduino by Jens Dalsgaard Nielsen, AAU
 * Studentspace  @ Aalborg University
 * http://es.aau.dk/staff/jdn
 * 
 * Find this code at github.com/jdn-aau/div
 * 
 * This program is for setting frequency and baudrate on the
 * apc220 radio using an arduino.
 * 
 * I is not able to setup the advanced features like network ID etc
 * In that case you need the apc220 config program (windows)
 * 
 * HOW TO USE IT ...........................
 * 
 * Upload this program to your Arduino UNO
 * (not to be used with DUE and other non AVR architectures)
 * 
 * 1) Attach radio to dig pin 8-13:
 *   
   >ARDUINO UNO<
  ---------------
  |      A   aref
  |      R    GND-++-GND-------------
  |      D     13 ++ 5V             |=antenna =======>
  IOREF  U     12 -- ENABLE(high)   |
  RESET  I     11 ++ RX             |
  3.3V   N     10 ++ TX             |
  5V     O     09 -- not used       |
  GND          08-++ CONFIG(low)----|
  GND    P      |
  |      B   ~ 06
  A0         ~ 05
  A1           04
  A2         ~ 03
  A3           02
  A4        TX 01
  A5        RX 00
  ---------------
 *
 * Program will search for the radio and if find you will get a menu
 * for programming and reading radio
 * 
 * 
 * 2) Radio on AAU cansatshield or radio just connected to hw tx,rx
 * 
 * Remember jumpers to the radio tx/rx (and setpin on shield v4)
 * NB if you are going to upload a new program remove the jumpers temporarily
 * To enable programming the setup pin on the radio must be set LOW
 * The program is pin 8 in the program but it can be changed by changing SETPIN
 * AAU shield v 4 can jumper the setpin to dig pin 8. If you have an older shield 
 * or just the radio connected to the hw tx/rx you must use a piece of wire
 * NB the hw serial port can of course be changed (looking the source)
 * 
 * The program will search for the radio and if present and setpin is reachable the
 * radio will be programmed with the parameters found in the top of the main
 * 
 * SO IF YOU HAVE TO PROGRAM MORE SHIELDS WITH DIFFERENT FREQUENCIES THEN
 * 1. change parms
 * 2. upload the new program
 * 3. restart arduino
 * 
 */
