/**
   (C) 2021

   Jens Dalsgaard Nielsen <jdn@es.aau.dk>
   http://es.aau.dk/staff/jdn
   http://jensd.dk
   Section of Automation & Control
   Aalborg University,
   Denmark

   "THE BEER-WARE LICENSE" (frit efter PHK)
   <jdn@es.aau.dk> wrote this file. As long as you
   retain this notice you can do whatever you want
   with this stuff, but You shall add your
   name and email and date for your
   modification.

   If we meet some day, and you think
   this stuff is worth it ...
   you can buy me a beer in return :-)
   or if you are real happy then ...
   single malt will be well received :-)

   Use it at your own risk - no warranty

**/

#ifndef _APC220CONFIG_H
#define _APC220CONFIG_H
#include "Arduino.h"
#include <SoftwareSerial.h>


// RX pin is YOUR rx pin and shall be connected to APC220 TX pin, etc

class apc220SWconfig : public SoftwareSerial {

  public:
    apc220SWconfig(int RXPin, int TXPin, int setPin) : SoftwareSerial(RXPin, TXPin)
    {
      _setPin = setPin;
     // begin(9600);
      pinMode(_setPin, OUTPUT);
    };

    int rdCfg(char *reply)
    {
      char rd;
      int cnt =0;

      apc220ToSetMode();

      write("RD\r\n");
      delay(200 + 30); // 200 datasheet - 30 then all chars has arrived

      while (available()) {
        rd =  (char) read();
        *reply = rd;
        reply++;
        cnt++;
      }
      reply -= 2;
      *reply = 0x00;
      apc220ToNormalMode();
      if (cnt == 21)    // <PARA xxxxxx x x x x\n\r"  == 21
                        //  12345678901234567890 1 
        return 0;
      else
        return -1;
    }

    void wrCfg(const char *cmd)
    {
      char rd;
      
      // we get 412000 3 9 3 0
      //        01234567890123
      apc220ToSetMode();
      write("WR ");
      for (int i=0; i < 14;i++) {
        write(*(cmd+i));
      }
      write("\r\n");  // expected from apc220

      delay(200 + 35); // 200 datasheet - add 35 so all chars has arrived

      while (available()) {
        rd =  (char) read(); // clear reply
      }
      apc220ToNormalMode();
    }

  private:
    void apc220ToSetMode(void)
    {
      digitalWrite(_setPin, LOW);
      delay(10); // 2acc datasheet (1msec)
    };

    void apc220ToNormalMode()
    {
      delay(10);
      digitalWrite(_setPin, HIGH);
      delay(2); // acc datasheet (1msec)
    };

  protected:
    int _setPin;

};



class apc220HWconfig{

  public:
    apc220HWconfig(HardwareSerial *p, int setPin) 
    {
        s = p;
        _setPin = setPin;
        pinMode(_setPin, OUTPUT);
    };
    
    void begin(long b) 
    {
      s->begin(b);
    }

    void println(char *ss)
    {
      s->println(ss);
    } 
   
    int rdCfg(char *reply)
    {
      char rd;
      int cnt =0;

      apc220ToSetMode();

      s->write("RD\r\n");
      delay(200 + 30); // 200 datasheet - 30 then all chars has arrived

      while (s->available()) {
        rd =  (char) (s->read());
        *reply = rd;
        reply++;
        cnt++;
      }
      reply -= 2;
      *reply = 0x00;
      apc220ToNormalMode();
      if (cnt == 21)    // <PARA xxxxxx x x x x\n\r"  == 21
                        //  12345678901234567890 1
        return 0;
      else
        return -1;
    }

    void wrCfg(const char *cmd)
    {
      char rd;
      
      // we get 412000 3 9 3 0
      //        01234567890123
      apc220ToSetMode();
      s->write("WR ");
      for (int i=0; i < 14;i++) {
        s->write(*(cmd+i));
      }
      s->write("\r\n");  // expected from apc220

      delay(200 + 35); // 200 datasheet - add 35 so all chars has arrived

      while (s->available()) {
        rd =  (char)(s-> read()); // clear reply
      }
      apc220ToNormalMode();
    }

  private:
    void apc220ToSetMode(void)
    {
      digitalWrite(_setPin, LOW);
      delay(10); // 2acc datasheet (1msec)
    };

    void apc220ToNormalMode()
    {
      delay(10);
      digitalWrite(_setPin, HIGH);
      delay(2); // acc datasheet (1msec)
    };

  protected:
    HardwareSerial *s;
    int _setPin;
};




#endif /* not defined _APC220CONFIG_H */


/* 
Some specs for apc220

- Frequency: 415MHz to 455MHz (1kHz step +-100Hz)
- GFSK modulation
- Channel spacing 200KHz(at least JDN)
- Max Output power: 20mW (10 level adjustable)
- Sensitivity: -117dB@1200bps
- Air data rate: 1200 to 19200bps. 
- UART baud rate: 1200 to 19200bps.
- Serial parity: 8E1\/8N1\/8O1  
- Data buffer: 512bytes
- Humidity: 10%～90%  
- Temperature: -30℃ - 85℃
- Supply voltage: 3.4 – 5.5V (the ripple is ±50mV )
- Transmit current: 35mA   
- Receiving current:32mA
- Sleeping current: 5uA  
- RF line-in-sight range:1000m (2400 baud)

*/
