#include "apc220cfg.h"

// just whoing how to embed embedded reprogram of apc220 in your program

// There is a hardware serial port and software serial version
//

// we need to create a software serial port
// we dont need to do it for the hardware serial ports
// bq they are already created in the runtime systems
// MORE COMMENTS IN BOTTOM OF FILE
//

SoftwareSerial soft01(10, 11);

// just an easy interface to configure an apc220 on the port

apc220cfg soft01cfg(&soft01, 8);
apc220cfg serialcfg(&Serial, 5);
// --------------------------^-- dig pin to force apc in prog mode
//--------------------^--------- reference to serial port


char x[34];


void drawRadio8to13()
{
	Serial.println(F(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> "));
	Serial.println(F("Attach radio directly to Arduino on pin 8 to gnd as shown below"));
	Serial.println(F("or solder some wires so you can connect the radio on the shields"));
	Serial.println(F("to 8,10,11,13 and 14. Remove any jumpers on shield "));
	Serial.println(F(" "));
	Serial.println(F("  ---------------"));
	Serial.println(F("  |      A   aref"));
	Serial.println(F("  |      R    GND-++-GND---------------"));
	Serial.println(F("  |      D     13 ++ 5V               |=======antenna =======>"));
	Serial.println(F("  |      U     12 -- ENABLE(high)     |"));
	Serial.println(F("  |      I     11 ++ RX               |"));
	Serial.println(F("  |      N     10 ++ TX               |"));
	Serial.println(F("  5V     O     09 -- not used         |"));
	Serial.println(F("  GND          08-++ SET/CONFIG(low)--|"));
	Serial.println(F("  ---------------"));
	Serial.println(F("  |          ~ 07"));
	Serial.println(F("  |          ~ 06"));
	Serial.println(F("  |          ~ 05"));
	Serial.println(F("  |            04"));
	Serial.println(F("  |          ~ 03"));
	Serial.println(F("  |            02"));
	Serial.println(F("  |         TX 01"));
	Serial.println(F("  |         RX 00"));
	Serial.println(F("  ---------------"));
	Serial.println(F("Remember to connect5V(pin13) to 5V as p13 cant give enough power"));
}


void setupHlp()
{
	Serial.println(F("config string: FFFFFF R P B C"));
	Serial.println(F("  example: 434,000 MHz 9600 baud in air, 20mW, 9600baud on UART, No Parity(8N1)"));
	Serial.println(F("           434000 3 9 3 0 is..."));
	Serial.println(F("           FFFFFF: Radio frequency in kHz"));
	Serial.println(F("           R:      Rf data rate       - 1/2/3/4 equals 2400(1km)/4800/9600/19200bps"));
	Serial.println(F("           P:      Radio output power - 0 .. 9 9 equals 13dBm(20mW)."));
	Serial.println(F("           B:      UART baudrate      - 0/1/2/3/4/5/6 equals 1200/2400/4800/9600/19200/38400/57600bps"));
	Serial.println(F("           C:      Byte Chek Parity   - 0/1/2 equals NoCheck(8N1)/EvenParity(8E1)/OddParity(8O1)"));
	Serial.println(F("           Frequency 415MHz to 455MHz (1kHz step +-100Hz)"));
	Serial.println(F("           Channel spacing 200KHz(at least /JDN))"));
	Serial.println(F("           NB the apc220 has broader frequency band than the allowd ISM band:"));
}


void setapc220pin8to13()
{
	int res;
	// insert radio
	Serial.println("bef start");
	drawRadio8to13();
	setupHlp();
	
	// we need to give rtadio power and enable by dig pins 12 and 13
 	pinMode(13, OUTPUT);
	digitalWrite(13, HIGH); // power on
	
	pinMode(12, OUTPUT);
	digitalWrite(12, HIGH); // enable radio
	
	delay(500); // to stabilize radio - too much time but ...
	
	// read, configure and read soft serial port
	res = soft01cfg.rdCfg(x); // returns 0 if ok, otherwise -1
	if (res == 0) {
		Serial.println(x);
	}
	else {
		Serial.print("no radio found");
		Serial.println(res);
	}
	
	soft01cfg.wrCfg("412000 2 9 3 0"); // See manual for expl
	
	// show new config
	
	if (0 == soft01cfg.rdCfg(x)) {
		Serial.println("rd2");
		Serial.println(x);
	}
	else {
		Serial.println(x);
		Serial.println("no radio2");
	}
	
}


void setapc220Serial()
{
	int res;
	// HW SERIAL
	// use on radio on std serial port.
	// a lite bit nasty bq
	// you cant have radio and usb serial in parallel
	// but you can configure radio
	// and you can on cansat shield
	// connect read connection  to openlog til radio so you can see answers¨
	// and look in the logfile on the sdcard
	// or just compare what you get from the radio with
	// the config strign and see if they are equal.
	//Jen
	delay(500);
	Serial.println("bef start - hw serial: Serial");
	
	delay(500); // to stabilize radio - too much time but ...
	
	// read, configure and read soft serial port
	res = serialcfg.rdCfg(x); // returns 0 if ok, otherwise -1
	
	if (res == 0) {
		Serial.println(x);
	}
	else {
		Serial.print("no radio found");
		Serial.println(res);
	}
	
	serialcfg.wrCfg("412000 2 9 3 0");
	
	if (0 == serialcfg.rdCfg(x)) {
	 	//Serial.println(x);
	}
	else {
		// bad bad no radio or proper reply read
	}
}

void setup() {
	int res;
	// put your setup code here, to run once:
	Serial.begin(9600); // initalise direct
	soft01.begin(9600); // initalise direct
	
	
	// SOFTSERIAL
	
	setapc220pin8to13();

    // setapc220Serial(); 
	
	
}

 

void loop() {}
