#include "apc220cfg.h"

SoftwareSerial soft01(10, 11);  // RX, TX

// just an easy interface to configure an apc220 on the port

apc220cfg soft01cfg(&soft01, 8);

// --------------------------^-- dig pin to force apc in prog mode
//--------------------^--------- reference to serial port


char x[34];


void drawRadio8to13()
{
  Serial.println(F(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> "));
  Serial.println(F("Attach radio directly to Arduino on pin 8 to gnd as shown below"));
  Serial.println(F("or solder some wires so you can connect the radio on the shields"));
  Serial.println(F("to 8,10,11,13 and 14. Remove any jumpers on shield "));
  Serial.println(F(" "));
  Serial.println(F("  ---------------"));
  Serial.println(F("  |      A   aref"));
  Serial.println(F("  |      R    GND-++-GND---------------"));
  Serial.println(F("  |      D     13 ++ 5V               |=======antenna =======>"));
  Serial.println(F("  |      U     12 -- ENABLE(high)     |"));
  Serial.println(F("  |      I     11 ++ RX               |"));
  Serial.println(F("  |      N     10 ++ TX               |"));
  Serial.println(F("  5V     O     09 -- not used         |"));
  Serial.println(F("  GND          08-++ SET/CONFIG(low)--|"));
  Serial.println(F("  ---------------"));
  Serial.println(F("  |          ~ 07"));
  Serial.println(F("  |          ~ 06"));
  Serial.println(F("  |          ~ 05"));
  Serial.println(F("  |            04"));
  Serial.println(F("  |          ~ 03"));
  Serial.println(F("  |            02"));
  Serial.println(F("  |         TX 01"));
  Serial.println(F("  |         RX 00"));
  Serial.println(F("  ---------------"));
  Serial.println(F("Remember to connect5V(pin13) to 5V as p13 might no be able"));
  Serial.println(F("to give enough power for normal op"));
}


void setup() {
  int res;
  // put your setup code here, to run once:
  Serial.begin(9600); // initalise direct
  soft01.begin(9600); // initalise direct

  drawRadio8to13();
  // SOFTSERIAL  Radio on dig pin d8 to d14

  // we need to give radio power and enable by dig pins 12 and 13
  pinMode(13, OUTPUT);
  digitalWrite(13, HIGH); // power on

  pinMode(12, OUTPUT);
  digitalWrite(12, HIGH); // enable radio

  delay(500); // to stabilize radio - too much time but ...

  soft01cfg.wrCfg("412000 3 9 3 0");

  res = soft01cfg.rdCfg(x);
  if (res == 0) {
    // yes
    Serial.println(x);
  }
}



void loop() {}
