 /*****************************************************
 * HDLC byte stuffing package                         *
 *                                                    *
 *  Created on: Dec 2013                              *
 *      Author: jdn                                   *
 *                                                    *
 ******************************************************
 *                                                    *
 *                                                    *
 * (C) 2012,2013                                      *
 *                                                    *
 * Jens Dalsgaard Nielsen <jdn@es.aau.dk>             *
 * http://www.control.aau.dk/~jdn                     *
 * Studentspace/Satlab                                *
 * Section of Automation & Control                    *
 * Aalborg University,                                *
 * Denmark                                            *
 *                                                    *
 * "THE BEER-WARE LICENSE" (frit efter PHK)           *
 * <jdn@es.aau.dk> wrote this file. As long as you    *
 * retain this notice you can do whatever you want    *
 * with this stuff. If we meet some day, and you think*
 * this stuff is worth it ...                         *
 *  you can buy me a beer in return :-)               *
 * or if you are real happy then ...                  *
 * single malt will be well received :-)              *
 *                                                    *
 * Use it at your own risk - no warranty              *
 ******************************************************
*
* we assume that rx and tx you supply will return 0 for ok
* and something else for not ok. In that way you can
* "provide" timeout etc by yourself
* we assume every package has a crc16 chksum
*/

#include "hdlc.h"
/*  SIMPLE HDLC TX/RX
 * BYTE STUFFING VRS
 * Dont care about contents and flags
 * Need just an arry of bytes to send and length
 * and send function
 * supplied tx shall return 0 for ok 
 *
 * /Jens
 * flag == 0x7e !!!
 *
 * typical ax25 un [0x7e | address | control | info | fcs | 0x7e]
 */


//----------------------------------------------------------------------------
int hdlc_TX( int (*ch_tx)(char ch),  char *data ,int data_lgt)
{
  char c;
  int res;

  // first start hdlc
  if (HDLC_MAX_LGT < data_lgt) // dont like to long packages :-)
    return (-1);

  if ( 0 != (*ch_tx)(ch_tx,HDLC_FLAG)) // start
    goto exit;

  // next data
  while (data_lgt--) {
    c = *data;

	// are we going to byte stuff ?
    if (c != HDLC_FLAG  &&  c != HDLC_STUFF_CH) {
      res= (*ch_tx)(c);
    } 
    else {
      if (0 == (res = (*ch_tx)(HDLC_STUFF_CH)) ) {  // HDLC STUFF
        res = (*ch_tx)(c^BIT_FLIP);       // AND FLIP c 2 B SND
      }  

      if (res)
        goto exit;
      data++;
    }

	// end of hdlc frame
    if (0 != (*ch_tx)(HDLC_FLAG)) // start/stop
      goto exit;

    return (0); // ok
exit:
    return (-1); // err
  }
}

//----------------------------------------------------------------------------
static int stuff_rx( int (*ch_rx)(char *ch), char *c)
{

  RX(ch_rx,c);

  if (*c == HDLC_FLAG)
    return (0); // start or stop of frame

  if (*c == HDLC_STUFF_CH) {
    RX(ch_rx,c);
    *c ^= BIT_FLIP;
  }
  return (1);
exit:
  return (2);
}

//----------------------------------------------------------------------------
int hdlc_RX( int (*ch_rx)(char * ch), char old_delim, char *info , int *cnt, int max_lgt)
{
  // NB NB NB NO TIMEOUT
  char c;

  // do you want to receive longer package than I want to receive ?
  if (HDLC_MAX_LGT < max_lgt)
    return (-11);

  switch (old_delim) {
  case 0: // there is a hdlc delim from last time so skip forward
    break;
  case 1:
    do {   // skip until HDLC delimiter
      RX(ch_rx,&c);  // start
    } 
    while  (c != HDLC_FLAG);
    break;
  default : 
    ;
  }

  *cnt= 0;

  do {
    switch (stuff_rx(ch_rx,&c)) {
    case 0:
      return (0); // HDLC_FLAG
      break;
    case 1:
      break;
    case 2:
      return (-1); // cant read stuff
    default:
      return (-1); // never come here
    }
    *info = c;
    info ++;
    (*cnt)++;
  } 
  while (*cnt <= HDLC_MAX_LGT); // NASTY TODO

  // coming here means no last HDLC delimiter read and rx buffer is full
  // one try to get the delimiter
  RX(ch_rx,&c);
  if (c != HDLC_FLAG)
    goto exit; // err

  return (0);  // ok
exit:
  return (-1); // err
}

//----------------------------------------------------------------------------
int hdlc_skipBytestuff( int (*ch_rx)(char * ch))
{
  char c;

  c = 0x00;

  do {
    RX(ch_rx,&c);
  } 
  while (c != HDLC_FLAG);

  return (0);  // ok
exit:
  return (-1); // err
}


