/*
* JDN inspired by many :-) 
* (C) Jens Dalsgaard Nielsen
* Aalborg University - Denmark
* no warranty - free to use and modify
*
* Simple morse module for sound(tone) or just dig port
* Morse alphabeth in prog flash for saving space
* use only capital letters like ABC  not abc
* RULES
* 1 dash = 3 dots
* 1 dot between chars
* 7 dot between words
*/ 

#ifndef MORSE
#define MORSE

#define SOUNDFREQ 800
#include <avr/pgmspace.h>  // bq we have morse table in prog mem 
#include "Arduino.h"

extern int mSoundFreq;
/*
* CW PARIS is in total 50 dots: 
* So 30 PARIS/min  = 1 PARIS/2 sec -> dot time = 2000ms/50 = 40 msec/dot
*    50 ....         (60/50) sec /50  = 24 msec/dot
* P: .--.     2+4+4+2
* ch delim    +2
* A: ._       2+4
* ch delim +  2
* R: .-.      2+4+2
* ch delim   +2
* I: ..       2+2
* ch delim   +2
* S: ...     2+2+2
* word delim +6   (7 dots between words , 3 dots between chars
* ==================== 
   50 in all
          
* PARIS 30WPM PARIS  P: .--. .-  . ...  14+8+8+4+(6+6) word delim = 7 dot
*   = 46
* 30 wpm PARIS (as aausat3) 2 sec for 46 -> 2/46 = 43 msec pr dot  
*/
extern   int _pin;
extern   int _sound;
extern	 int _dotLength;

/**
* SYMBOL length
* 1 dash = 3 * dot
* 1 dot between dot/dash
* 3 dot between chars
* 3 dash between words (aka "space")
*/


/** sound: dash/dot by  0: HIGH/LOW  1: tone(SOUNDFREQ)
* pin:  arduino pin used for morsing
* dotLength: length of dot in msec
*
*/
int mInit(int sound, int pin,int dotLength);

/* one dot including one dot wait after */
void mDot();

/* one dash including one dot wait after */
void mDash();

/* wait time between chars 3* dot - NB assumes last dot/dash has already waited 1*dot */
void mcSpace();   

/* wait word space time: 7 * dot - NB assumes there is already 3*dot as end of char */
void mwSpace();

/*morse string like ".--.-..-."); or "... --- ..." - space = char delim
* a word delimiter by "... --- ...   ... --- ...   "  : word delim is 3 spaces
* if you want char or word delimiter in end of string then "... "(1 space equals char delim) 
* or "...   "(3 spaces = word delim)
*/
void morseDotDash(char c[]); 

/* morse char ABCDE 0-9 nto abc morseC('A')  dont do morseC('a') */
void morseC(char c);    

/* morse string - any space is interpreted as word delimiter */
void morseS(char c[]);  // string variant

/* morse int */
void morseI(int i);     // integer variant

#endif

