/******************************************************
 * pit.c                                              *
 *                                                    *
 *  Created on:         2013                          *
 *      Author: jdn                                   *
 *                                                    *
 ******************************************************
 *                                                    *
 *                                                    *
 * simple PID controller                              *
 *                                                    *
 * this version adapted for Arduino                   *
 *                                                    *
 * (C) 2012,2013                                      *
 *                                                    *
 * Jens Dalsgaard Nielsen <jdn@es.aau.dk>             *
 * http://www.control.aau.dk/~jdn                     *
 * Studentspace/Satlab                                *
 * Section of Automation & Control                    *
 * Aalborg University,                                *
 * Denmark                                            *
 *                                                    *
 * "THE BEER-WARE LICENSE" (frit efter PHK)           *
 * <jdn@es.aau.dk> wrote this file. As long as you    *
 * retain this notice you can do whatever you want    *
 * with this stuff. If we meet some day, and you think*
 * this stuff is worth it ...                         *
 *  you can buy me a beer in return :-)               *
 * or if you are real happy then ...                  *
 * single malt will be well received :-)              *
 *                                                    *
 * Use it at your own risk - no warranty              *
 * http://en.wikipedia.org/wiki/Talk:PID_controller#Velocity_Form_Pseudocode *
 http://www.20sim.com/webhelp/library_signal_control_pid_control_antiwindup.php
 
*****************************************************/

#include <pid.h>

float pPID(struct parmBlk *p, float setpoint,float actual_position)
{
  float error;
  float derivative;
  float output,abb;

  //Caculate P,I,D
  error = setpoint - actual_position;
  derivative = (error - p->pre_error)/p->dt;

  //In case of error too small then stop integration

  if (error < 0.0) // just to get size without sign
    abb = -error;
  else
    abb = error;


  // a limiter - if error is to small stop updating
  if ( p->epsilon < abb ) {
    p->integral = p->integral + error * p->dt;
  }


  output = (p->kp * error) + (p->ki * p->integral) + (p->kd * derivative);

  //Saturation - it is called i min(/max ut not vescessary current...
  if(output > p->imax) {
    output = p->imax;
  }	else if(output < p->imin)	{
    output = p->imin;
  }

  p->pre_error = error;//Update error

  return output;
}

