/******************************************************
 * pit.h                                              *
 *                                                    *
 *  Created on:         2013                          *
 *      Author: jdn                                   *
 *                                                    *
 ******************************************************
 *                                                    *
 *                                                    *
 * simple PID controller                              *
 *                                                    *
 * this version adapted for Arduino                   *
 *                                                    *
 * (C) 2012,2013                                      *
 *                                                    *
 * Jens Dalsgaard Nielsen <jdn@es.aau.dk>             *
 * http://www.control.aau.dk/~jdn                     *
 * Studentspace/Satlab                                *
 * Section of Automation & Control                    *
 * Aalborg University,                                *
 * Denmark                                            *
 *                                                    *
 * "THE BEER-WARE LICENSE" (frit efter PHK)           *
 * <jdn@es.aau.dk> wrote this file. As long as you    *
 * retain this notice you can do whatever you want    *
 * with this stuff. If we meet some day, and you think*
 * this stuff is worth it ...                         *
 *  you can buy me a beer in return :-)               *
 * or if you are real happy then ...                  *
 * single malt will be well received :-)              *
 *                                                    *
 * Use it at your own risk - no warranty              *
*****************************************************/


#ifndef PIDGEN
#define PIDGEN

#include <math.h>

#define P_EPSILON 0.01
#define P_DT 0.01
#define P_I_MAX  4
#define P_I_MIN -4
#define P_KP  0.1
#define P_KD  0.01
#define P_KI  0.005


struct parmBlk {
  float epsilon,
        dt,
        imin,
        imax,
        kp,
        kd,
        ki,
        pre_error,
        integral;
};

float pPID(struct parmBlk *p, float setpoint,float actual_position);

#endif
