/*
  This example shows how data can be sent from the satellite to the groundstation. The same functions work the other way around as well, and can be used to send data to the satellite from the groundstation.

  Caution - You should always have an antenna in a radio system before transmitting anything. Make sure the antenna is plugged in before sending data via the radio.
*/

#include "CanSatNeXT.h"

// Define our filepath. The / means that it is in the root of the sd-card.
String filepath = "/test.csv";

void setup() {

  // Initialize serial with baud rate 115200
  Serial.begin(115200);

  // Initialize CanSatNeXT systems. Calling this function with an address as a parameter enables the radio. The address is shared by both the transmitter and receiver. 
  CanSatInit(28);

}

void loop() {
  // Read acceleration
  float ax, ay, az;
  readAcceleration(ax, ay, az);

  // Construct text string containing sensor readings, separated by a semicolon
  String data = String(millis()) + ";" + String(ax) + ";" + String(ay) + ";" + String(az);

  // Replace decimal dot with comma to be read by Danish Excel
  data.replace(".", ",");

  // Send data over radio
  sendData(data);

  // Store data on SD card
  appendFile(filepath, data);

  // After appending the file with our value, let's add a line change
  // so that the file is easier to read
  appendFile(filepath, "\r\n");

  delay(10);
}