/****************************************************
 * APC220 config
 * A small arduino by Jens Dalsgaard Nielsen, AAU
 * Studentspace  @ Aalborg University
 * http://es.aau.dk/staff/jdn
 *
 * Find this code at github.com/jdn-aau/div
 *
 * This program is for setting frequency and baudrate on the
 * apc220 radio using an arduino.
 *
 * I is not able to setup the advanced features like network ID etc
 * In that case you need the apc220 config program (windows)
 * On the other hand I have never used these networking features.
 * If you want independent network I normally implement this by using
 * different frequencies.
 *
 * DIFFERENT VERSIONS
 * There are several versions of the apc220 radio which cover slightly
 * different frequency bands.
 * apc220-43 418-455 MHz
 * apc220 v4.c 431-475 MHz
 * It is difficult to obtain the correct information
 * One "rule" green PCB 475 MHz area
 *            yellw/orange  433 MHz area
 *
 *
 * HOW TO USE IT ...........................
 *
 * Upload this program to your Arduino UNO
 * (not to be used with DUE and other non AVR architectures)
 *
 * METHOD  1) Attach radio to dig pin 8-13:
 *
   >ARDUINO UNO<
  ---------------
  |      A   aref     >APC220 radio<
  |      R    GND-++-GND-------------
  |      D     13 ++ 5V             |=antenna =======>
  IOREF  U     12 -- ENABLE(high)   |
  RESET  I     11 ++ RX             |
  3.3V   N     10 ++ TX             |
  5V     O     09 -- not used       |
  GND          08-++ CONFIG(low)----|
  GND    P      |
  |      B   ~ 06
  A0         ~ 05
  A1           04
  A2         ~ 03
  A3           02
  A4        TX 01
  A5        RX 00
  ---------------
 *
 * Program will search for the radio and if find you will get a menu
 * for programming and reading radio
 *
 * R read settings
 * W write new settings
 *  w  FFFFFF R P B C - number of letters indicates precise number of digits
 *     FFFFFF: frequency: 434000 (434 MHz default ) range approx 418000-4/5000
 *     R:      Rf data rate       - 1/2/3/4 equals 2400(1km)/4800/9600/19200bps
 *     P:      Radio output power - 0 .. 9 9 equals 13dBm(20mW)
 *     B:      UART baudrate      - 0/1/2/3/4/5/6 equals 1200/2400/4800/9600/19200/38400/57600bps
 *     C:      Byte Chek Parity   - 0/1/2 equals NoCheck(8N1)/EvenParity(8E1)/OddParity(8O1)
 *
 * Write example: w 434000 3 9 3 0 is...
 *   434,000 MHz 9600 baud in air, 20mW, 9600baud on UART, No Parity(8N1)
 *
 *"p xx" FAST MODE
 * Instead of writing allt he stuff just issue p xx  - xx is an integer between 0 and ...
 * Radio will be programmed with settings in source. The xx will adjust the radio frequency with
 *   f = startF + xx * stepF
 *
 * METHOD 2) Radio on AAU cansatshield or radio just connected to hw tx,rx
 *
 * Remember jumpers to the radio tx/rx (and setpin on shield v4)
 * NB if you are going to upload a new program remove the jumpers temporarily
 * To enable programming the setup pin on the radio must be set LOW
 * The program is pin 8 in the program but it can be changed by changing SETPIN
 * AAU shield v 4 can jumper the setpin to dig pin 8. If you have an older shield
 * or just the radio connected to the hw tx/rx you must use a piece of wire
 * NB the hw serial port can of course be changed (looking the source)
 *
 * The program will search for the radio and if present and setpin is reachable the
 * radio will be programmed with the parameters found in the top of the main
 *
 * SO IF YOU HAVE TO PROGRAM MORE SHIELDS WITH DIFFERENT FREQUENCIES THEN
 * 1. change parms in program source
 * 2. recompile upload the new program
 * 3. restart arduino
 * 4. await action :-)
 *
 */

 /* CAPACITY CAPACITY
 * The apc220 has 256 byte buffer onboard for TX and RX
 * But
 * 1. dont fill buffer (is you have higher uart baudrate than air baudrat)
 * 2. average flow must be below half of air bandwidth because the apc radio add
 *    redundance to the info stream so errors can be corrected.
 *   To be safe be below 50% of nominal air bandwidth - and lower is you will be sure!!!
 *   
 */
  
