/**----------------------------------------------------------------------------------*/
void configModeOn()
{
  digitalWrite(SETPIN, LOW); // config mode on
  delay(60);
}

/**----------------------------------------------------------------------------------*/
void configModeOff()
{
  digitalWrite(SETPIN, HIGH); // config mode off
}

/**----------------------f------------------------------------------------------------*/
void configPinInit()
{
  pinMode(SETPIN, OUTPUT);

}

/**----------------------------------------------------------------------------------*/
void radioOn()
{
  digitalWrite(enPin, HIGH);
  delay(100);
}

/**----------------------------------------------------------------------------------*/
void radioOff()
{
  digitalWrite(enPin, LOW);
  delay(100);
}

/**----------------------------------------------------------------------------------*/
void radioConfig(int s)
{
  switch (shieldID) {
    case 0:
      {
        pinMode(FIVEV, OUTPUT); // 5V
        digitalWrite(FIVEV, HIGH); // turn on 5V
        enPin = ENPIN12;
        apc220.begin(9600);
        shieldID = s;

        break;
      }
    case 1: // for auto programming 
      {
        enPin = ENPIN7;
        Serial.begin(9600);
        shieldID = s;
        break;
      }

    default:
      {
        shieldID = -1;
      }
  }
  pinMode(enPin, OUTPUT);

  radioOn();
}


/**----------------------------------------------------------------------------------*/
void radioWriteCh(char x)
{
  if (! shieldID)
    apc220.write(x);
  else
    Serial.write(x);
}

/**----------------------------------------------------------------------------------*/
void radioWrite(char x[])
{
  if (! shieldID)
    apc220.print(x);
  else
    Serial.print(x);
}

/**----------------------------------------------------------------------------------*/
void radioPrintln(char x[])
{
  if (! shieldID)
    apc220.println(x);
  else
    Serial.println(x);
}

void radioPrint(char x[])
{

  if (! shieldID  )
    apc220.print(x);
  else
    Serial.print(x);
}

/**----------------------------------------------------------------------------------*/
int radioAvailable()
{
  if (! shieldID )
    return apc220.available();
  else
    return Serial.available();
}

/**----------------------------------------------------------------------------------*/
int radioRead()
{

  if (! shieldID  )
    return apc220.read();
  else
    return Serial.read();
}
