#include <Wire.h>

#include <bmp085.h>

float temp, pres, atm, alt;

void setup()
{
  Serial.begin(115200);
  bmp085_init();
}

int i=0;

void loop()
{
  temp = bmp085GetTemperature(bmp085ReadUT()); //MUST be called first for every measurements
  pres = bmp085GetPressure(bmp085ReadUP());
  atm = pres / 101325; // "standard atmosphere"
  alt = calcAltitude(pres); //Uncompensated caculation - in Meters 

 if (i == 0) {
    i = 5;
    Serial.println("Temp    |    pres   |     atm    | alt : ");
  }
  i= i-1;

  Serial.print(temp, 2); //display 2 decimal places
  Serial.print(" C | ");

  Serial.print(pres, 0); //whole number only.
  Serial.print(" Pa | ");

  Serial.print(atm, 4); //display 4 decimal places
  Serial.print("  | ");
  Serial.print(alt, 2); //display 2 decimal places
  Serial.print(" M  ");
 
 Serial.println(millis());
 // delay(1000);
}




