#include <Wire.h>
#include <bmp085.h>

float temp,atm,alt;
long pres;
 
#define LOOPTIME 200
#define STDATM 101325

void setup()
{
  Serial.begin(9600);
  Serial.println("Test af tryk/temp maaler bmp085 paa Arduino CANSAT shield");
  Serial.println(" du kan i koden aendre dagens luftryk aht hojde");
  Serial.print(STDATM);
  Serial.println(" benyttes som tryk ved havoverfladen - kan ændres");
  bmp085_Init();
}

void loop()
{
 //  bmp085_init();
  temp = bmp085Temp(); 
  pres = bmp085Pressure(); 

  atm = 100.0 * pres / STDATM; // "standard atmosphere"
  alt = bmp085PascalToMeter(pres,STDATM);  
  
  Serial.print(temp);
  Serial.print(" (C)  ");

  Serial.print(pres);
  Serial.print(" (Pa)  ");
  
  Serial.print(atm);
  Serial.print(" (rel) ");

  Serial.print(alt);
  Serial.println( " (m) ");
 
}






