
#include <Wire.h>

#include <looptime.h>
#include <bmp085.h>
#include <linscale.h>
#include <mma7361l.h>

void setup() 
{
  Serial.begin(9600);
  mma7361lInit(8);
  // calib with -/+ 1g from 1.5g and 6g range 
  // get numbers from calib15g6g

  mma7361lInitX(183,512,312,399);
  mma7361lInitY(181,522,316,405);
  mma7361lInitZ(150,482,296,386);
  bmp085_init();
}
float temp, pres, alt;
void loop()
{
  temp = bmp085Temp(); 
  pres = bmp085Pressure(); 
  alt = bmp085PascalToMeter(pres,100770);  
  mma7361lMea();
  // hereafter mma7361l ax/ay/az and r holds accelerations
  Serial.print(mma7361lax,4); 
  Serial.print("   ");
  Serial.print(mma7361lay,4); 
  Serial.print("   ");
  Serial.print(mma7361laz,4); 
  Serial.print("   ");
  Serial.print(mma7361lr,4);
  Serial.print(" ");
  Serial.print(temp);
  Serial.print(" ");
  Serial.print(pres);
  Serial.print(" ");
  Serial.println(alt);
  looptime(100); // loopcode takes approx 25msec so 75 millisec free
}



