#include <Wire.h>
#include <bmp085.h>
#include "MPU6050.h"


MPU6050 accelgyro(0x68);
#define OUTPUT_READABLE_ACCELGYRO



void setup()
{
  Serial.begin(9600);
  Wire.begin();

  bmp085Init(101900.0); // ress at sealevel today
  accelgyro.initialize();
  if (accelgyro.testConnection()) {
    Serial.println("MPU6050 ok ");
  }
  else {
    Serial.println("MPU6050 fail ");
    while (1);  // stop here
  }
  accelgyro.setFullScaleAccelRange(2 ); // 8g


}
// praecis tid

unsigned long tStart, tSlut;  // 0 -- 4 mia

int16_t gx, gy, gz;
int16_t ax, ay, az;
void loop()
{
  float tryk, temp, hojde;

  tStart = millis();  // hvad er klokken

  bmp085Measure(&temp, &tryk, &hojde);
  // "tid" : "temp" :  "tryk"  :  "hojde"
  Serial.print( millis() ); Serial.print(" : ");
  Serial.print( temp );     Serial.print(" : ");
  Serial.print( tryk );     Serial.print(" : ");
  Serial.print( hojde, 5 );  Serial.print(" : ");
  Serial.print("  ");
  accelgyro.getMotion6(&ax, &ay, &az, &gx, &gy, &gz);
  Serial.print("a/g:\t");
  Serial.print(ax); Serial.print("  :  ");
  Serial.print(ay); Serial.print("  :  ");
  Serial.print(az); Serial.print("  :  ");
  Serial.print(gx); Serial.print("  :  ");
  Serial.print(gy); Serial.print("  :  ");
  Serial.print(gz); Serial.println(" ");

  tSlut = millis(); // hvad er klokken nu

  delay(100  - (tSlut - tStart) );
}
