/* standard program til AAU shield 
 * der medsendes relativ i millisekunder
 * Tidstaelleren har en max vaerdi hvorefter den wrapper rundt
 * og starter fra nul af
 * 
 */

int raaMaaling;
float temp, tryk,acc_x,acc_y,acc_z;

unsigned long tid, tidEfter, startTid;
unsigned long loopCnt=0;
int soveTid;
int forsteGang=1;

float maaletalTilVolt(int maaletal)
{
  return maaletal *5.0/1023; /* Der er 1024 step til 5V*/
}

void setup()
{
  /* set kommunikationshastighed til 9600 baud
   * svarer til ca 900 karakterer/sekund
   */
   Serial.begin(9600);
}

 
void loop()
{
  /* hent tid */
  cli(); /* disable interrupt - dvs ro */
  tid = millis(); /* hent tid i millisekunder */
  sei();
  
  if (forsteGang)
  {
    startTid = tid;
    forsteGang=0;
  }
  
  raaMaaling = analogRead(0); /* tryk */
  raaMaaling = analogRead(0); /* igen for at faa stabil maaling*/
  temp      = maaletalTilVolt(raaMaaling);
  
  raaMaaling = analogRead(1); /* temperatur */
  raaMaaling = analogRead(1);  /* igen for at faa stabil maaling*/
  tryk       = maaletalTilVolt(raaMaaling);
  
  raaMaaling = analogRead(2); /* acceleration x */
  raaMaaling = analogRead(2); /* igen for at faa stabil maaling*/
  acc_x      = maaletalTilVolt(raaMaaling);
  
  raaMaaling = analogRead(3); /* acceleration y */
  raaMaaling = analogRead(3); /* igen for at faa stabil maaling*/
  acc_y      = maaletalTilVolt(raaMaaling);
  
  raaMaaling = analogRead(4); /* acceleration z */
  raaMaaling = analogRead(4); /* igen for at faa stabil maaling*/
  acc_z      = maaletalTilVolt(raaMaaling);
  
  /* send tid som er unsigned long dvs 0.. ca 4 mia eller 4 mio sekunder */
  Serial.print(tid); Serial.print(" ");
  /* send data med mellem(space) imellem 
   */
  Serial.print(tryk); Serial.print(" ");
  Serial.print(temp); Serial.print(" ");
  Serial.print(acc_x); Serial.print(" ");
  Serial.print(acc_y); Serial.print(" ");
  Serial.print(acc_z); Serial.println(" ");

  cli(); /* disable interrupt - dvs ro */
  tidEfter = millis(); /* hent tid i millisekunder */
  sei();
  
  
  //soveTid = 100 - (tidEfter - tid);
  loopCnt = loopCnt+1;
  soveTid = (loopCnt*100 + startTid) - tidEfter;
  delay(soveTid); /* vent 100 msec */


  /* Ønske om 100 msec loop tid - vi skal sove ... */
  
}
  
