#include <looptime.h>
#include <linscale.h>

/*
simple program which read acc x,y,z
 convert to float by scaling parms 
 (use -1g and 1g meas by cansat/calibacc
 This program to auto switch between 1.5 and 6.0g
 
 NB NBNB Calib
 
 Use program  JDN sketches -> mma7631 ->calib15g6g
 */

struct linscaletp acc15x,acc15y,acc15z,
acc6x, acc6y, acc6z;

void setup()
{
  Serial.begin(9600);
  linscaleinit(&acc15x,183,-1.0,515,1.0); // -1g and 1g meas
  linscaleinit(&acc15y,181,-1.0,524,1.0);
  linscaleinit(&acc15z,150,-1.0,483,1.0);

  pinMode(8,OUTPUT);
  digitalWrite(8,LOW);
  linscaleinit(&acc6z,306,-1.0,392,1.0);
  linscaleinit(&acc6z,308,-1.0,396,1.0);
  linscaleinit(&acc6z,292,-1.0,381,1.0);

}

float ax,ay,az,r;
void loop()
{
  ax = linscale(analogRead(2),&acc15x);
  ay = linscale(analogRead(3),&acc15y);
  az = linscale(analogRead(1),&acc15z);
  if ( (1.5 < abs(ax)) || (1.5 < abs(ay)) || (1.5 < abs(az)) ) {

    digitalWrite(8,HIGH);

    ax = linscale(analogRead(2),&acc6x);
    ay = linscale(analogRead(3),&acc6y);
    az = linscale(analogRead(1),&acc6z);

    digitalWrite(8,LOW);
  }

  Serial.print(ax); 
  Serial.print(" , ");
  Serial.print(ay); 
  Serial.print(" , ");
  Serial.print(az); 
  Serial.print(" , ");
  r = sqrt(ax*ax+ay*ay+az*az);
  Serial.println(r);
  looptime(50);
}





