 /*
* Simple NTC SW
* 10 kohm fixed in series with...
*  >>> 10 kOhm NTC <<<  with B25/85 3977 in Vishay docu
* 5 Volt from Arduino
* range 0-1023 = 0-5V 
* Data from Vishay ntcle100e3
* B 25/85 = 3977
* with the following Steinhart & Hart factors
* #ifdef NTC3977
* #define NTC_A -14.6337
* #define NTC_B 4791.842
* 
* #define NTC_A1 3.354016E-03
* #define NTC_B1 2.569850E-04
* #define NTC_C1 2.620131E-06
* #define NTC_D1 6.383091E-08
*/
#define NTC_A1 3.354016E-03
#define NTC_B1 2.569850E-04
#define NTC_C1 2.620131E-06
#define NTC_D1 6.383091E-08

#define NTC_R 10000.0
#define ADC_Q 1024

#define FIXED_R 10000
#define V_SUP 5.0
void setup() {
  Serial.begin(9600);
}

double tmp()
{
  int i;
  double t, v, r, l;
  i = analogRead(A0); // 10 bit so [0 - 1023] == [0 - V_SUP] = [0 - 5.0V]

  v = V_SUP*i/ADC_Q;

  r = v * (FIXED_R) / (V_SUP - v);
  l = log(r / NTC_R);
  // steinhart & hart formula (2) on page two in datasheet
  // see circuit above in figure
  t = 1.0/ (NTC_A1 + NTC_B1 * l + NTC_C1 * l * l + NTC_D1 * l * l * l);
  return t;
}
void loop() {
  Serial.println(tmp()-273.15); // subtract 273.15 bq temp is in Kelvin
  delay(100);
}


#ifdef NEVER
/*
NTC NTCLE100E3
--------------
If you have a 3.3 ohm then define ..   #define NTC2880 etc

See Steinhart & Hart parameters below

AND LIFT THIS TO TOP OF FILE :-)

/Jens
Ohm B-25/85
3.3 2880
4.7 2880
6.8 2880
10 2990
15 3041
22 3136
33 3390
47 3390
68 3390
100 3560
150 3560
220 3560
330 3560
470 3560
680 3560
1000 3528
1500 3528
2000 3528
2200 3977
2700 3977
3300 3977
4700 3977
5000 3977
6800 3977
10000 3977
12000 3740
15000 3740
22000 3740
33000 4090
47000 4090
50000 4190
68000 4190
100000 4190
150000 4370
220000 4370
330000 4570
470000 4570
*/
 
#ifdef NTC2880
#define NTC_A -9.094
#define NTC_B 2251.74
#define NTC_C 229098
#define NTC_D -2.744820E+07
#define NTC_A1 3.354016E-03
#define NTC_B1 3.495020E-04
#define NTC_C1 2.095959E-06
#define NTC_D1 4.260615E-07
//NTC2880 3 -9.094 2251.74 229098 -2.744820E+07 3.354016E-03 3.495020E-04 2.095959E-06 4.260615E-07
#endif

#ifdef NTC2990
#define NTC_A -10.2296
#define NTC_B 2887.62
#define NTC_C 132336
#define NTC_D -2.502510E+07
#define NTC_A1 3.354016E-03
#define NTC_B1 3.415560E-04
#define NTC_C1 4.955455E-06
#define NTC_D1 4.364236E-07
//NTC2990 3 -10.2296 2887.62 132336 -2.502510E+07 3.354016E-03 3.415560E-04 4.955455E-06 4.364236E-07
#endif

#ifdef NTC3041
#define NTC_A -11.1334
#define NTC_B 3658.73
#define NTC_C -102895
#define NTC_D 5.166520E+05
#define NTC_A1 3.354016E-03
#define NTC_B1 3.349290E-04
#define NTC_C1 3.683843E-06
#define NTC_D1 7.050455E-07
//NTC3041 3 -11.1334 3658.73 -102895 5.166520E+05 3.354016E-03 3.349290E-04 3.683843E-06 7.050455E-07
#endif

#ifdef NTC3136
#define NTC_A -12.4493
#define NTC_B 4702.74
#define NTC_C -402687
#define NTC_D 3.196830E+07
#define NTC_A1 3.354016E-03
#define NTC_B1 3.243880E-04
#define NTC_C1 2.658012E-06
#define NTC_D1 -2.701560E-07
//NTC3136 3 -12.4493 4702.74 -402687 3.196830E+07 3.354016E-03 3.243880E-04 2.658012E-06 -2.701560E-07
#endif

#ifdef NTC3390
#define NTC_A -12.6814
#define NTC_B 4391.97
#define NTC_C -232807
#define NTC_D 1.509643E+07
#define NTC_A1 3.354016E-03
#define NTC_B1 2.993410E-04
#define NTC_C1 2.135133E-06
#define NTC_D1 -5.672000E-09
//NTC3390 3 -12.6814 4391.97 -232807 1.509643E+07 3.354016E-03 2.993410E-04 2.135133E-06 -5.672000E-09
#endif

#ifdef NTC3528
#define NTC_A -12.0596
#define NTC_B 3687.667
#define NTC_C -7617.13
#define NTC_D -5.914730E+06
#define NTC_A1 3.354016E-03
#define NTC_B1 2.909670E-04
#define NTC_C1 1.632136E-06
#define NTC_D1 7.192200E-08
//NTC3528 0.5 -12.0596 3687.667 -7617.13 -5.914730E+06 3.354016E-03 2.909670E-04 1.632136E-06 7.192200E-08
#endif

#ifdef NTC3528
#define NTC_A -21.0704
#define NTC_B 11903.95
#define NTC_C -2504699
#define NTC_D 2.470338E+08
#define NTC_A1 3.354016E-03
#define NTC_B1 2.933908E-04
#define NTC_C1 3.494314E-06
#define NTC_D1 -7.712690E-07
//NTC3528 0.5 -21.0704 11903.95 -2504699 2.470338E+08 3.354016E-03 2.933908E-04 3.494314E-06 -7.712690E-07
#endif

#ifdef NTC3560
#define NTC_A -13.0723
#define NTC_B 4190.574
#define NTC_C -47158.4
#define NTC_D -1.199256E+07
#define NTC_A1 3.354016E-03
#define NTC_B1 2.884193E-04
#define NTC_C1 4.118032E-06
#define NTC_D1 1.786790E-07
//NTC3560 1.5 -13.0723 4190.574 -47158.4 -1.199256E+07 3.354016E-03 2.884193E-04 4.118032E-06 1.786790E-07
#endif

#ifdef NTC3470
#define NTC_A -13.8973
#define NTC_B 4557.725
#define NTC_C -98275
#define NTC_D -7.522357E+06
#define NTC_A1 3.354016E-03
#define NTC_B1 2.744032E-04
#define NTC_C1 3.666944E-06
#define NTC_D1 1.375492E-07
//NTC3470 2.0  -13.8973 4557.725 -98275 -7.522357E+06 3.354016E-03 2.744032E-04 3.666944E-06 1.375492E-07
#endif

#ifdef NTC3977
#define NTC_A -14.6337
#define NTC_B 4791.842
#define NTC_C -115334
#define NTC_D -3.730535E+06
#define NTC_A1 3.354016E-03
#define NTC_B1 2.569850E-04
#define NTC_C1 2.620131E-06
#define NTC_D1 6.383091E-08
//NTC3977 0.75 -14.6337 4791.842 -115334 -3.730535E+06 3.354016E-03 2.569850E-04 2.620131E-06 6.383091E-08
#endif

#ifdef NTC4090
#define NTC_A -15.5322
#define NTC_B 5229.973
#define NTC_C -160451
#define NTC_D -5.414091E+06
#define NTC_A1 3.354016E-03
#define NTC_B1 2.519107E-04
#define NTC_C1 3.510939E-06
#define NTC_D1 1.105179E-07
//NTC4090 1.5 -15.5322 5229.973 -160451 -5.414091E+06 3.354016E-03 2.519107E-04 3.510939E-06 1.105179E-07
#endif

#ifdef NTC4190
#define NTC_A -16.0349
#define NTC_B 5459.339
#define NTC_C -191141
#define NTC_D -3.328322E+06
#define NTC_A1 3.354016E-03
#define NTC_B1 2.460382E-04
#define NTC_C1 3.405377E-06
#define NTC_D1 1.034240E-07
//NTC4190 1.5 -16.0349 5459.339 -191141 -3.328322E+06 3.354016E-03 2.460382E-04 3.405377E-06 1.034240E-07
#endif

#ifdef NTC4370
#define NTC_A -16.8717
#define NTC_B 5759.15
#define NTC_C -194267
#define NTC_D -6.869149E+06
#define NTC_A1 3.354016E-03
#define NTC_B1 2.367720E-04
#define NTC_C1 3.585140E-06
#define NTC_D1 1.255349E-07
//NTC4370 2.5 -16.8717 5759.15  -194267 -6.869149E+06 3.354016E-03 2.367720E-04 3.585140E-06 1.255349E-07
#endif

#ifdef NTC4570
#define NTC_A -17.6439
#define NTC_B 6022.726
#define NTC_C -203157
#define NTC_D -7.183526E+06
#define NTC_A1 3.354016E-03
#define NTC_B1 2.264097E-04
#define NTC_C1 3.278184E-06
#define NTC_D1 1.097628E-07
//NTC4570 1.5 -17.6439 6022.726 -203157 -7.183526E+06 3.354016E-03 2.264097E-04 3.278184E-06 1.097628E-07
#endif

 

#endif

