
#include <WiFi.h>
 
uint8_t macA[6];

void getMACAddr(uint8_t *mac)
{
  WiFi.macAddress(mac);
}

void setup() {
  Serial.begin(115200);
  delay(300);
  Serial.println();
  Serial.print("ESP Board MAC Address:  ");
  getMACAddr(macA);
}

void printMAC(uint8_t *mac)
{
  for (int i = 0; i < 6; i++) {
    Serial.print(" Ox");
    if (mac[i] <= 9)
      Serial.print("0");
    Serial.print(mac[i], HEX);
  }
}

void loop() {

  printMAC(macA);
  Serial.println();
  delay(600);
}
