
//Arduino 1.0+ only
#include <Wire.h>
#include <l3g4200.h> 

#define ANTAL 10
int x,y,z;
long xsum=0,ysum=0,zsum=0;
int xoffset,yoffset,zoffset;



void doCalib()
{
  for (int i=0 ; i < ANTAL; i++) {
    l3g4200DGetGyroValues(&x,&y,&z);
    xsum +=x; ysum +=y; zsum +=z;
    delay(100);
  }
  xoffset = xsum /ANTAL; // offset value
  yoffset = ysum /ANTAL; // offset value
  zoffset = zsum /ANTAL; // offset value
}

void setup(){

  Wire.begin();
  Serial.begin(9600);

  Serial.println("starting up L3G4200D- configure part - dont touch");
  l3g4200DSetup(2000); // Configure L3G4200  - 250, 500 or 2000 deg/sec
  delay(1500); // wait to be stable
  doCalib();
  Serial.println("calibration ended");
  xoffset=yoffset=zoffset=0;
}

void loop(){
  l3g4200DGetGyroValues(&x,&y,&z);
  Serial.print("X:");
  Serial.print(x-xoffset);

  Serial.print(" Y:");
  Serial.print(y-yoffset);

  Serial.print(" Z:");
  Serial.println(z-zoffset);

  delay(100); //Just here to slow down the serial to make it more readable
}



 
 
