
#include <l3g4200.h>
#include <Arduino.h>
#include <Wire.h>
#define byte char

static void writeRegister(int deviceAddress, byte address, byte val) {
    Wire.beginTransmission(deviceAddress); // start transmission to device 
    Wire.write(address);       // send register address
    Wire.write(val);         // send value to write
    Wire.endTransmission();     // end transmission
}

static int readRegister(int deviceAddress, byte address){

    int v; //L3G4200
    Wire.beginTransmission(deviceAddress);
    Wire.write(address); // register to read
    Wire.endTransmission();

    Wire.requestFrom(deviceAddress, 1); // read a byte

    while(!Wire.available()) {
        // waiting
    }

    v = Wire.read();
    return v;
}

void l3g4200DGetGyroValues(int *x, int *y, int *z){


  byte yMSB = readRegister(L3G4200D_Address, 0x2B);
  byte yLSB = readRegister(L3G4200D_Address, 0x2A);
  *y = ((yMSB << 8) | yLSB);

  byte xMSB = readRegister(L3G4200D_Address, 0x29);
  byte xLSB = readRegister(L3G4200D_Address, 0x28);
  *x = ((xMSB << 8) | xLSB);

  byte zMSB = readRegister(L3G4200D_Address, 0x2D);
  byte zLSB = readRegister(L3G4200D_Address, 0x2C);
  *z = ((zMSB << 8) | zLSB);
}

 

int l3g4200DSetup(int scale){
  //From  Jim Lindblom of Sparkfun's code

  // Enable x, y, z and turn off power down:
  writeRegister(L3G4200D_Address, L3G4200_CTRL_REG1, 0b00001111);

  // If you'd like to adjust/use the HPF(high passs filter), you can edit the line below to configure L3G4200_CTRL_REG2:
//JDN   http://forum.arduino.cc/index.php?topic=183407.15 writeRegister(L3G4200D_Address, L3G4200_CTRL_REG2, 0b00000000);  
  writeRegister(L3G4200D_Address, L3G4200_CTRL_REG2, 0b00010000);

  // Configure L3G4200_CTRL_REG3 to generate data ready interrupt on INT2
  // No interrupts used on INT1, if you'd like to configure INT1
  // or INT2 otherwise, consult the datasheet:
//  writeRegister(L3G4200D_Address, L3G4200_CTRL_REG3, 0b00001000);
  writeRegister(L3G4200D_Address, L3G4200_CTRL_REG3, 0b00000000);

  // L3G4200_CTRL_REG4 controls the full-scale range, among other things:
 
  if(scale == 250){
    writeRegister(L3G4200D_Address, L3G4200_CTRL_REG4, 0b00000000);
  }else if(scale == 500){
    writeRegister(L3G4200D_Address, L3G4200_CTRL_REG4, 0b00010000);
  }else{
    writeRegister(L3G4200D_Address, L3G4200_CTRL_REG4, 0b00110000);
  }

  // L3G4200_CTRL_REG5 controls high-pass filtering of outputs, use it
  // if you'd like:
  writeRegister(L3G4200D_Address, L3G4200_CTRL_REG5, 0b0001011);
// writeRegister(L3G4200D_Address, L3G4200_CTRL_REG5, 0b00000000);
}

 
