 /*
* Simple NTC SW
* 10 kohm fixed in series with...
*  v 0.921
* (C) JDN free beer license
*
* setup in this program example
*
* 10 kOhm series and 10 kOhm NTC
*
*   5V ----|10 kohm|-----|10 kohm NTC|----GND
*              ^       ^
*       ntc fixed      |
*                     analogRead(A0)
*
* NB 10 bit AD converter so reading from ADC
* is scaled from range 0-1023 to 0-5V
* 5 Volt from Arduino
* range 0-1023 = 0-5V 
* Data from Vishay ntcle100e3
* B 25/85 = 3977
* with the following Steinhart & Hart factors
* #ifdef NTC3977
* #define NTC_A -14.6337
* #define NTC_B 4791.842
* 
* #define NTC_A1 3.354016E-03
* #define NTC_B1 2.569850E-04
* #define NTC_C1 2.620131E-06
* #define NTC_D1 6.383091E-08
*/
#define NTC_A1 3.354016E-03
#define NTC_B1 2.569850E-04
#define NTC_C1 2.620131E-06
#define NTC_D1 6.383091E-08

#define NTC_R 10000.0
#define ADC_Q 1024

#define FIXED_R 10000
#define V_SUP 5.0
void setup() {
  Serial.begin(9600);
}

float NTC_temp()
{
  int i;
  float t, v, r, l;
  i = analogRead(A0); 

  v = V_SUP*i/ADC_Q; // 10 bit so [0 - 1023] == [0 - V_SUP] = [0 - 5.0V]

  r = v * (FIXED_R) / (V_SUP - v);
  l = log(r / NTC_R);
  
  // steinhart & hart formula (2) on page two in datasheet
  // see circuit above in figure
  t = 1.0/ (NTC_A1 + NTC_B1 * l + NTC_C1 * l * l + NTC_D1 * l * l * l);
  return t; // in Kelvin !
}

void loop() {
  Serial.println(NTC_temp()-273.15); // subtract 273.15 bq temp is in Kelvin
  delay(100);
}

