#include <crc16.h>

#define PLGT 30
unsigned char txPkg[PLGT];

void setL(unsigned char l)
{
  txPkg[5] = l;  // lsb int
  txPkg[6] = 0;  // msb int
}

void setHdr(unsigned char id)
{
  txPkg[0] = 0xff;
  txPkg[1] = 0xff;
  txPkg[2] = 0xfd;
  txPkg[3] = 0x00;
  txPkg[4] = id;
}

void doPing(char motorID)
{
  setHdr(motorID);
  setL(3);
  txPkg[7] = 0x01; // ping
  add_crc16(txPkg,10); // will place crc16 @ loc 8,9
}

void dmpPkg(unsigned char *p,  int l)
{
  for (int i = 0; i < l; i++) {
    Serial.print((int)p[i],HEX); Serial.print(" ");
  }
  Serial.println(" ende");
}
void setup() {
  Serial.begin(9600);
  doPing(0x01);
  Serial.print((int)txPkg[8],HEX); Serial.print(" "); Serial.println((int)txPkg[9],HEX);
  dmpPkg(txPkg,10);

}

void loop() {
  // put your main code here, to run repeatedly:

}
