 
/*
* SIMPLE NTC CODE FOR 10 kohm NTC
* ARDUINO STUFF :-)
* (C) JDN free beer license
* setup
*   5V ----|10 kohm|-----|10 kohm NTC|----GND
*              ^       ^
*       ntc fixed      |
*                     analogRead(A0)
*
* NB 10 bit AD converter so reading from ADC
* is scaled from range 0-1023 to 0-5V
*/
#ifdef NEVER
#include <Arduino.h>
#include "ntc.h"

float rRef,NTC_A1,NTC_B1,NTC_C1,NTC_D1;

void setNtcParms(float rReff, float a1,float b1, float c1, float d1)
{
  rRef = rReff;
  NTC_A1 = a1;
  NTC_B1 = b1;
  NTC_C1 = c1;
  NTC_D1 = d1;
}

float ntcToTemp(float r)
{
float logV,vv,t;
 
  //formula t = 1.0 / (NTC_A1 + NTC_B1 * logV + NTC_C1 * logV * logV + NTC_D1 * logV * logV * logV);
  // doing a little bit more efficient ...
  
  vv = logV = log(r /rRef); 

  t = NTC_A1 + NTC_B1 * vv;
  
  vv *= logV;  // logV^2
  t += NTC_C1 * vv;  
 
  vv *= logV;   // logV^3
  t += NTC_D1 * vv;
  
  return (1.0 / t); // in Kelvin !!!
}
  
float tempToNtc(float Rref, float t)
{
float tmp;
  // R = Rref * exp(A +B/T + C/T^2 + D/T3)
  
  tmp = NTC_A;
  tmp += NTC_B/t;
  tmp += NTC_C/(t*t);
  tmp += NTC_D/(t*t*t);
  
  return   Rref * exp(tmp);
}

#endif
