#include "ctiic.h"
#include "delay.h"	 


//I2Cٶȵʱ
void CT_Delay(void)
{
	delay_us(1);
} 
//ݴоƬIICӿڳʼ
void CT_IIC_Init(void)
{					     
 	RCC->APB2ENR|=1<<3;		//ʹIO PORTBʱ    
	GPIOB->CRH&=0XFFFF00FF;	//PB10,PB11 
	GPIOB->CRH|=0X00003300;
    GPIOB->ODR|=0<<11;	    //PB11 	 	
	GPIOB->ODR|=0<<10;	    //PB10 	 
	
}
//IICʼź
void CT_IIC_Start(void)
{
	CT_SDA_OUT();     //sda
	CT_IIC_SDA=1;	  	  
	CT_IIC_SCL=1;
	CT_Delay();
 	CT_IIC_SDA=0;//START:when CLK is high,DATA change form high to low 
	CT_Delay();
	CT_IIC_SCL=0;//ǯסI2Cߣ׼ͻ 
}	  
//IICֹͣź
void CT_IIC_Stop(void)
{ 
	CT_SDA_OUT();//sda
	CT_IIC_SCL=0;
	CT_IIC_SDA=0;
	CT_Delay();
	CT_IIC_SCL=1;
	CT_Delay();
	CT_IIC_SDA=1;//STOP:when CLK is high DATA change form low to high 
}
//ȴӦźŵ
//ֵ1Ӧʧ
//        0Ӧɹ
u8 CT_IIC_Wait_Ack(void)
{
	u16 ucErrTime=0;
	CT_SDA_IN();      //SDAΪ  
	CT_IIC_SDA=1;delay_us(1);	   
	while(CT_READ_SDA)
	{
		ucErrTime++;
		if(ucErrTime>20000)
		{
			CT_IIC_Stop();
			return 1;
		} 
	}
	CT_IIC_SCL=1;delay_us(1);	 
	CT_IIC_SCL=0;//ʱ0 	   
	return 0;  
} 
//ACKӦ
void CT_IIC_Ack(void)
{
	CT_IIC_SCL=0;
	CT_SDA_OUT();
	CT_IIC_SDA=0;
	CT_Delay();
	CT_IIC_SCL=1;
	CT_Delay();
	CT_IIC_SCL=0;
}
//ACKӦ		    
void CT_IIC_NAck(void)
{
	CT_IIC_SCL=0;
	CT_SDA_OUT();
	CT_IIC_SDA=1;
	CT_Delay();
	CT_IIC_SCL=1;
	CT_Delay();
	CT_IIC_SCL=0;
}					 				     
//IICһֽ
//شӻӦ
//1Ӧ
//0Ӧ			  
void CT_IIC_Send_Byte(u8 txd)
{                        
    u8 t;   
	CT_SDA_OUT(); 	    
    CT_IIC_SCL=0;//ʱӿʼݴ
    for(t=0;t<8;t++)
    {              
        CT_IIC_SDA=(txd&0x80)>>7;
        txd<<=1; 	      
		CT_IIC_SCL=1;
		CT_Delay();
		CT_IIC_SCL=0;	
		CT_Delay();
    }	 
} 	    
//1ֽڣack=1ʱACKack=0nACK   
u8 CT_IIC_Read_Byte(unsigned char ack)
{
	u8 i,receive=0;
 	CT_SDA_IN();//SDAΪ
    for(i=0;i<8;i++ )
	{
    CT_IIC_SCL=0;
    CT_Delay();    
		//delay_us(30);
		CT_IIC_SCL=1;  
		receive<<=1;
		if(CT_READ_SDA)receive++;   
	}	  				 
	if (!ack)CT_IIC_NAck();//nACK
	else CT_IIC_Ack(); //ACK   
 	return receive;
}




























