#include "ft3517U.h"
#include "touch.h"
#include "ctiic.h"
#include "usart.h"
#include "delay.h" 
#include "string.h" 
#include "hw_config.h"


#include "CST148.h"
 u32   g_cst3xx_ic_version  = 0;
 u32   g_cst3xx_ic_checksum = 0;
 u32   g_cst3xx_ic_checkcode =0;
 u32   g_cst3xx_ic_project_id  = 0;
 u32   g_cst3xx_ic_type  = 0;
 
static unsigned char *pcst3xx_update_firmware = (unsigned char *)cst3_fw ; //the updating firmware

#define CST3XX_BIN_SIZE    (24*1024 + 24)
#define HYN_ADDR_WR         (0x1A<<1)
#define HYN_ADDR_RD		   ((0x1A<<1)+1)
//#define HYN_UPDATE_FIRMWARE_ENABLE
//#define HYN_UPDATE_FIRMWARE_POWERON_ENABLE

static int cst3xx_i2c_read( unsigned char *buf, int len)
{
	int ret = 0;

	u8 i; 
 	CT_IIC_Start(); 
	CT_IIC_Send_Byte(HYN_ADDR_RD);	//д 	 
	CT_IIC_Wait_Ack(); 	 
	for(i=0;i<len;i++)
	{	   
    	buf[i]=CT_IIC_Read_Byte(i==(len-1)?0:1); //	  
	} 
    CT_IIC_Stop();//һֹͣ 
	return ret;
}

static int cst3xx_i2c_write( unsigned char *buf, int len)
{
	int ret = -1;
	u8 i;

	CT_IIC_Start();	
	CT_IIC_Send_Byte(HYN_ADDR_WR);	//д 	 
	ret=CT_IIC_Wait_Ack();
	if(ret){
		printf("1 CT_IIC_Wait_Ack error . \r\r\n");
	};  
	for(i=0;i<len;i++)
	{	   
      CT_IIC_Send_Byte(buf[i]);  	//
		 ret=CT_IIC_Wait_Ack();   //0:normal 1: error
		 if(ret){	
				printf("2 CT_IIC_Wait_Ack error . \r\r\n");			 
			break;  
		 }
	}
    CT_IIC_Stop();					//һֹͣ	    
	if(ret) ret=-1;
	return ret;
}

static int cst3xx_i2c_read_register( unsigned char *buf, int len)
{
	int ret = -1;

    ret = cst3xx_i2c_write( buf, 2);
		if(ret < 0){
			printf("write err\r\n");
		}
    ret = cst3xx_i2c_read( buf, len);

    return ret;
}





static int cst3xx_into_program_mode(void)
{
	int ret;
	unsigned char buf[4];

	buf[0] = 0xA0;
	buf[1] = 0x01;
	buf[2] = 0xAA;	//set cmd to enter program mode
	ret = cst3xx_i2c_write( buf, 3);
	if (ret < 0)  return -1;

	delay_ms(2);

	buf[0] = 0xA0;
	buf[1] = 0x02;	//check whether into program mode
	ret = cst3xx_i2c_read_register( buf, 1);
	if (ret < 0)  return -1;

	if (buf[0] != 0x55) return -1;

	return 0;
}
static int cst3xx_erase_program_area(void )
{
	int ret;
	unsigned char buf[3];

	buf[0] = 0xA0;
	buf[1] = 0x02;
	buf[2] = 0x00;		//set cmd to erase main area
	ret = cst3xx_i2c_write( buf, 3);
	if (ret < 0) return -1;

	delay_ms(5);

	buf[0] = 0xA0;
	buf[1] = 0x03;
	ret = cst3xx_i2c_read_register( buf, 1);
	if (ret < 0)  return -1;

	if (buf[0] != 0x55) return -1;

	return 0;
}


static void cst3xx_reset_ic(unsigned int ms)
{

/*
	gpio_direction_output(ts->pdata->reset_gpio,0);
	delay_ms(2);
	gpio_direction_output(ts->pdata->reset_gpio,1);
*/
//	unsigned char buf[4];
//	buf[0] = 0xD1;
//	buf[1] = 0x0E;	 
//	cst3xx_i2c_write(buf, 2);
  
	GPIO_ResetBits(GPIOB,GPIO_Pin_0);	
	delay_ms(10);
	GPIO_SetBits(GPIOB,GPIO_Pin_0);	
	delay_ms(ms);
}


static int cst3xx_write_program_data( unsigned char *pdata)
{
	int i, ret;
	//unsigned char *i2c_buf;
	unsigned short eep_addr;
	int total_kbyte;

	unsigned char temp_buf[8];
	unsigned short iic_addr;
	int  j;
	u8 i2c_buf[1024 + 2];


//	i2c_buf = kmalloc(sizeof(unsigned char)*(1024 + 2), GFP_KERNEL);
//	if (i2c_buf == NULL)
	//	return -1;

	//make sure fwbin len is N*1K
	//total_kbyte = len / 1024;
	total_kbyte = 24;
	for (i=0; i<total_kbyte; i++) {
		i2c_buf[0] = 0xA0;
		i2c_buf[1] = 0x14;
		eep_addr = i << 10;		//i * 1024
		i2c_buf[2] = eep_addr;
		i2c_buf[3] = eep_addr>>8;
		ret = cst3xx_i2c_write( i2c_buf, 4);
		if (ret < 0)
			goto error_out;

		memcpy(i2c_buf, pdata + eep_addr, 1024);
		for(j=0; j<256; j++) {
			iic_addr = (j<<2);
    	temp_buf[0] = (iic_addr+0xA018)>>8;
    	temp_buf[1] = (iic_addr+0xA018)&0xFF;
		temp_buf[2] = i2c_buf[iic_addr+0];
		temp_buf[3] = i2c_buf[iic_addr+1];
		temp_buf[4] = i2c_buf[iic_addr+2];
		temp_buf[5] = i2c_buf[iic_addr+3];
    	      ret = cst3xx_i2c_write( temp_buf, 6);
    		if (ret < 0)
    			goto error_out;
		}

		i2c_buf[0] = 0xA0;
		i2c_buf[1] = 0x04;
		i2c_buf[2] = 0xEE;
		ret = cst3xx_i2c_write( i2c_buf, 3);
		if (ret < 0)
			goto error_out;

		delay_ms(60);

		i2c_buf[0] = 0xA0;
		i2c_buf[1] = 0x05;
		ret = cst3xx_i2c_read_register( i2c_buf, 1);
		if (ret < 0)
			goto error_out;

		if (i2c_buf[0] != 0x55)
			goto error_out;

	}

	i2c_buf[0] = 0xA0;
	i2c_buf[1] = 0x03;
	i2c_buf[2] = 0x00;
	ret = cst3xx_i2c_write( i2c_buf, 3);
	if (ret < 0)
		goto error_out;

	delay_ms(8);

	if (i2c_buf != NULL) {
		//kfree(i2c_buf);
		//i2c_buf = NULL;
	}

	return 0;

error_out:
	if (i2c_buf != NULL) {
		//kfree(i2c_buf);
		//i2c_buf = NULL;
	}
	return -1;
}


static int cst3xx_check_checksum(void)
{
	int ret;
	int i;
	unsigned int  checksum;
	unsigned int  bin_checksum;
	unsigned char buf[4];
	const unsigned char *pData;

	for(i=0; i<5; i++)
	{
		buf[0] = 0xA0;
		buf[1] = 0x00;
		ret = cst3xx_i2c_read_register( buf, 1);
		if(ret < 0)
		{
			delay_ms(2);
			continue;
		}

		if(buf[0]!=0)
			break;
		else
		delay_ms(2);
	}
    delay_ms(2);


    if(buf[0]==0x01)
	{
		buf[0] = 0xA0;
		buf[1] = 0x08;
		ret = cst3xx_i2c_read_register( buf, 4);

		if(ret < 0)	return -1;

		// read chip checksum
		checksum = buf[0] + (buf[1]<<8) + (buf[2]<<16) + (buf[3]<<24);

        pData=(unsigned char  *)pcst3xx_update_firmware +24*1024+16;   //7*1024 +512
		bin_checksum = pData[0] + (pData[1]<<8) + (pData[2]<<16) + (pData[3]<<24);

        printf("  hyn the updated ic checksum is :0x%x. the updating firmware checksum is:0x%x------\r\r\n", checksum, bin_checksum);

        if(checksum!=bin_checksum)
		{
			printf(" cst3xx hyn check sum error.\r\r\n");
			return -1;

		}

	}
	else
	{
		printf(" cst3xx hyn No checksum.\r\r\n");
		return -1;
	}
	return 0;
}

static int cst3xx_exit_program_mode()
{
	int ret;
	unsigned char buf[3];

	buf[0] = 0xA0;
	buf[1] = 0x06;
	buf[2] = 0xEE;
	ret = cst3xx_i2c_write( buf, 3);
	if (ret < 0)
		return -1;

	delay_ms(10);	//wait for restart


	return 0;
}


static int cst3xx_update_firmware( unsigned char *pdata)
{
	int ret;
	int retry = 0;

	printf(" cst3xx----------upgrade cst3xx begain------------\r\r\n");
	delay_ms(20);
START_FLOW:

#ifdef HYN_UPDATE_FIRMWARE_POWERON_ENABLE
	close_vcc3v3Power();
	delay_ms(20);
	open_vcc3v3Power();
	delay_ms(5+retry);
#else
	cst3xx_reset_ic(5+retry);
#endif
	ret = cst3xx_into_program_mode();
	if (ret < 0) {
		printf(" cst3xx[cst3xx]into program mode failed.\r\r\n");
		goto err_out;
	}

	ret = cst3xx_erase_program_area();
	if (ret) {
		printf(" cst3xx[cst3xx]erase main area failed.\r\r\n");
		goto err_out;
	}

	ret = cst3xx_write_program_data( pdata);
	if (ret < 0) {
		printf(" cst3xx[cst3xx]write program data into cstxxx failed.\r\r\n");
		goto err_out;
	}

    ret =cst3xx_check_checksum();
	if (ret < 0) {
		printf(" cst3xx[cst3xx] after write program cst3xx_check_checksum failed.\r\r\n");
		goto err_out;
	}

	ret = cst3xx_exit_program_mode();
	if (ret < 0) {
		printf(" cst3xx[cst3xx]exit program mode failed.\r\r\n");
		goto err_out;
	}

	cst3xx_reset_ic(20);

	printf(" cst3xx hyn----------cst3xx_update_firmware  end------------\r\r\n");

	return 0;

err_out:
	if (retry < 30) {
		retry++;
		delay_ms(20);
		goto START_FLOW;
	}
	else {
		return -1;
	}
}




/*******************************************************
Function:
    get firmware version, ic type...
Input:
    client: i2c client
Output:
    success: 0
    fail:	-1
*******************************************************/
static int cst3xx_firmware_info()
{
	int ret;
	unsigned char buf[28];
//	unsigned short ic_type, project_id;

	printf("cst3xx_firmware_info . \r\r\r\n");


	buf[0] = 0xD1;
	buf[1] = 0x01;
	ret = cst3xx_i2c_write(buf, 2);
	if (ret < 0) {
		printf("cst3xx write D101 ERROR. \r\r\r\n");
		return -1;
	}

	delay_ms(40);

	buf[0] = 0xD1;
	buf[1] = 0xFC;
	ret = cst3xx_i2c_read_register(buf, 4);
	if (ret < 0) {
		printf("cst3xx write D1FC ERROR. \r\r\n");
		return -1;
	}

	//0xCACA0000
	g_cst3xx_ic_checkcode = buf[3];
	g_cst3xx_ic_checkcode <<= 8;
	g_cst3xx_ic_checkcode |= buf[2];
	g_cst3xx_ic_checkcode <<= 8;
	g_cst3xx_ic_checkcode |= buf[1];
	g_cst3xx_ic_checkcode <<= 8;
	g_cst3xx_ic_checkcode |= buf[0];

	printf("linc cst3xx [cst3xx] the chip g_cst3xx_ic_checkcode:0x%x.\r\r\n",g_cst3xx_ic_checkcode);
	
	delay_ms(2);
	
	buf[0] = 0xD2;
	buf[1] = 0x04;
	ret = cst3xx_i2c_read_register(buf, 4);
	if (ret < 0) return -1;
	g_cst3xx_ic_type = buf[3];
	g_cst3xx_ic_type <<= 8;
	g_cst3xx_ic_type |= buf[2];

	
	g_cst3xx_ic_project_id = buf[1];
	g_cst3xx_ic_project_id <<= 8;
	g_cst3xx_ic_project_id |= buf[0];

	printf("linc cst3xx [cst3xx] the chip ic g_cst3xx_ic_type :0x%x, g_cst3xx_ic_project_id:0x%x\r\r\n",
		g_cst3xx_ic_type, g_cst3xx_ic_project_id);

	delay_ms(2);
	
	buf[0] = 0xD2;
	buf[1] = 0x08;
	ret = cst3xx_i2c_read_register( buf, 8);
	if (ret < 0) return -1;	

	g_cst3xx_ic_version = buf[3];
	g_cst3xx_ic_version <<= 8;
	g_cst3xx_ic_version |= buf[2];
	g_cst3xx_ic_version <<= 8;
	g_cst3xx_ic_version |= buf[1];
	g_cst3xx_ic_version <<= 8;
	g_cst3xx_ic_version |= buf[0];

	g_cst3xx_ic_checksum = buf[7];
	g_cst3xx_ic_checksum <<= 8;
	g_cst3xx_ic_checksum |= buf[6];
	g_cst3xx_ic_checksum <<= 8;
	g_cst3xx_ic_checksum |= buf[5];
	g_cst3xx_ic_checksum <<= 8;
	g_cst3xx_ic_checksum |= buf[4];	

	printf(" cst3xx [cst3xx] the chip ic version:0x%x, checksum:0x%x\r\r\n",
		g_cst3xx_ic_version, g_cst3xx_ic_checksum);

	if(g_cst3xx_ic_version==0xA5A5A5A5)
	{
		printf(" cst3xx [cst3xx] the chip ic don't have firmware. \r\n");
		return -1;
	}
	if((g_cst3xx_ic_checkcode&0xffff0000)!=0xCACA0000){
		printf("linc cst3xx [cst3xx] cst3xx_firmware_info read error .\r\r\n");
		return -1;
	}

  buf[0] = 0xD1;
	buf[1] = 0x09;
	ret = cst3xx_i2c_write( buf, 2);
	if (ret < 0) return -1;
    delay_ms(5);


	return 0;
}

static int cst3xx_update_judge( unsigned char *pdata, int strict)
{
	unsigned short ic_type, project_id;
	unsigned int fw_checksum, fw_version;
	const unsigned int *p;
	int i;
	unsigned char *pBuf;

	fw_checksum = 0x55;
	p = (const unsigned int *)pdata;
	for (i=0; i<(CST3XX_BIN_SIZE-4); i+=4) {
		fw_checksum += (*p);
		p++;
	}

	if (fw_checksum != (*p)) {
		printf(" cst3xx[cst3xx]calculated checksum error:0x%x not equal 0x%x.\r\n", fw_checksum, *p);
		return -1;	//bad fw, so do not update
	}

	pBuf = &pdata[CST3XX_BIN_SIZE-16];

	project_id = pBuf[1];
	project_id <<= 8;
	project_id |= pBuf[0];

	ic_type = pBuf[3];
	ic_type <<= 8;
	ic_type |= pBuf[2];

	fw_version = pBuf[7];
	fw_version <<= 8;
	fw_version |= pBuf[6];
	fw_version <<= 8;
	fw_version |= pBuf[5];
	fw_version <<= 8;
	fw_version |= pBuf[4];

	fw_checksum = pBuf[11];
	fw_checksum <<= 8;
	fw_checksum |= pBuf[10];
	fw_checksum <<= 8;
	fw_checksum |= pBuf[9];
	fw_checksum <<= 8;
	fw_checksum |= pBuf[8];

	printf(" cst3xx[cst3xx]the updating firmware:project_id:0x%04x,ic type:0x%04x,version:0x%x,checksum:0x%x\r\n",
			project_id, ic_type, fw_version, fw_checksum);

	if (strict > 0) {

		if (g_cst3xx_ic_checksum != fw_checksum){



#ifdef HYN_UPDATE_FIRMWARE_ENABLE
				printf("[cst3xx]update firmware not enable.\r\n");
				return -1;
#endif
			
			if (g_cst3xx_ic_version >fw_version){
				printf("[cst3xx]fw version(0x%x), ic version(0x%x).\r\n",fw_version, g_cst3xx_ic_version);
				return -1;
			}
		}else{
			printf("[cst3xx]fw checksum(0x%x), ic checksum(0x%x).\r\n",fw_checksum, g_cst3xx_ic_checksum);
			return -1;
		}
	}

	return 0;
}
static int cst3xx_boot_update_fw(unsigned char *pdata)
{
	int ret;
	int retry = 0;
	int flag = 0;

	printf("cst3xx_boot_update_fw . \r\r\n");
	while (retry++ < 3) {
		ret = cst3xx_firmware_info( );
		if (ret == 0) {
			flag = 1;
			break;
		}
	}

	if (flag == 1) {
		ret = cst3xx_update_judge(pdata, 1);
		if (ret < 0) {
			printf(" cst3xx[cst3xx] no need to update firmware.\r\n");
			return 0;
		}
	}

	ret = cst3xx_update_firmware(pdata);
	if (ret < 0){
		printf(" cst3xx [cst3xx] update firmware failed.\r\n");
		return -1;
	}

    delay_ms(50);

	ret = cst3xx_firmware_info();
	if (ret < 0) {
		printf(" cst3xx [cst3xx] after update read version and checksum fail.\r\n");
		return -1;
	}

	return 0;
}
#if 0
u8 lastPoint = 0;
u8 HYN_CST148_Scan(void)
{
	unsigned char buf[30];
	unsigned char i2c_buf[8];
	unsigned char finger_id, sw;
	unsigned int  input_x = 0; 
	unsigned int  input_y = 0; 
	unsigned int  input_w = 0;
  unsigned char cnt_up, cnt_down;
	int   i,j, ret, idx,a; 
	int cnt=0, i2c_len;
	int   sum1=0,sum2=0;

	u8 TouchPoint = 0;
  u8 tempPoint = 0;
	u8 flag = 0;
    printf("linc cst3xx HYN_CST148_Scan enter. \r\n");

	buf[0] = 0xD0;
	buf[1] = 0x00;
	ret = cst3xx_i2c_read_register( buf, 9);
	if(ret < 0) {
		printf(" linc iic read touch point data failed.\r\n");
		goto OUT_PROCESS;
	}
		
	if(buf[6] != 0xAB) {
		//printf(" linc data is not valid..\r\r\n");
		goto OUT_PROCESS;
	}

	if(buf[5] == 0x80) {	
		goto END;
	} 
	
	cnt = buf[5] & 0x7F;
	if(cnt > 5) goto OUT_PROCESS;
	else if(cnt==0)     goto CLR_POINT;
	
	if(cnt == 0x01) {
		goto FINGER_PROCESS;
	} 
	else {

		if ((buf[5]&0x80) == 0x80) {
			buf[5] = 0xD0;
			buf[6] = 0x07;
			i2c_len = (cnt - 1)*5 + 3;
			ret = cst3xx_i2c_read_register( &buf[5], i2c_len);
			if (ret < 0)
				goto OUT_PROCESS;
			i2c_len += 5;

		} 
		else {			
			buf[5] = 0xD0;
			buf[6] = 0x07;			
			i2c_len = (cnt - 1)*5 + 1;
			ret = cst3xx_i2c_read_register( &buf[5], i2c_len);
			if (ret < 0)
				goto OUT_PROCESS;
			i2c_len += 5;
		}
		if (buf[i2c_len - 1] != 0xAB) {
			goto OUT_PROCESS;
		}
	}	
	
FINGER_PROCESS:

	i2c_buf[0] = 0xD0;
	i2c_buf[1] = 0x00;
	i2c_buf[2] = 0xAB;
	ret = cst3xx_i2c_write( i2c_buf, 3);
	if(ret < 0) {
		printf("linc cst3xx hyn send read touch info ending failed.\r\r\n"); 
		cst3xx_reset_ic(20);
	}
	
	  idx = 0;
    cnt_up = 0;
    cnt_down = 0;
 	  sum1= buf[8]<<8|buf[7];
	for(a=0;a<7;a++){
		sum2+=buf[a];
	}
	printf("cst3xx point checksum sum1:%d,sum2:%d. \r\n", sum1, sum2);
	if(sum1!=sum2){
		goto OUT_PROCESS;
	}
	for (i = 0; i < cnt; i++) {
		
		input_x = (unsigned int)((buf[idx + 1] << 4) | ((buf[idx + 3] >> 4) & 0x0F));
		input_y = (unsigned int)((buf[idx + 2] << 4) | (buf[idx + 3] & 0x0F));	
		input_w = (unsigned int)(buf[idx + 4]);
		sw = (buf[idx] & 0x0F) >> 1;
		finger_id = (buf[idx] >> 4) & 0x0F;
  
        printf("linc cst3xx Point x:%d, y:%d, id:%d, sw:%d. \r\n", input_x, input_y, finger_id, sw);

		    tp_dev.tp_sta[i] = sw;
        tp_dev.tp_id[i] = finger_id;  
        tp_dev.x[i] = (1080-(u16)input_x) * 4095/1080;//0~1080
        tp_dev.y[i] = (1920-(u16)input_y)* 4095/1920;//0~1920
        if(tp_dev.x[i] > 4095 || tp_dev.x[i] < 0){
          tp_dev.x[i] = 0x00;
          //return 0;
        }
        if(tp_dev.y[i] > 4095 || tp_dev.y[i] < 0){
          tp_dev.y[i] = 0x00;
          //return 0;
        }
        printf("tp_dev.tp_sta[%d]=%d\r\r\n",i,tp_dev.tp_sta[i]);
         printf("tp_dev.tp_id[%d]=%d\r\r\n",i,tp_dev.tp_id[i]);
				printf("tp_dev.x[%d]=%d\r\r\n",i,tp_dev.x[i]);
				printf("tp_dev.y[%d]=%d\r\r\n",i,tp_dev.y[i]);
        if(tp_dev.tp_sta[i] == 0x03){//put down
          tp_dev.tp_sta[i] = 0x06;
        }else if(tp_dev.tp_sta[i] != 0x03){//put up
          tp_dev.tp_sta[i] = 0x07;
        }
		if (sw == 0x03) {
            cnt_down++;
        }else {
            cnt_up++;
        }
		idx += 5;
	}




//    if(lastPoint > TouchPoint){/*һδȽϷд㱻ͷ*/
//		if(TouchPoint == 0){
//			for(i = 0; i < lastPoint; i++){
//			tp_dev.tp_sta[i] = 0x06;
//			tp_dev.tp_id[i] = tp_dev.last_id[i];
//			tp_dev.x[i] = tp_dev.last_x[i];
//			tp_dev.y[i] = tp_dev.last_y[i];
//			}
//			MulTouch_Send(tp_dev.x,tp_dev.y,tp_dev.tp_sta,tp_dev.tp_id,lastPoint);
//			lastPoint = TouchPoint;
//			return 0;
//		}
//        tempPoint = TouchPoint;
//        //printf("lastPoint=%d\r\r\n",lastPoint);
//        //printf("TouchPoint=%d\r\r\n",TouchPoint);
//        for(i = 0; i < lastPoint; i++){/*ѰҳͷŵĴ㡣ͷŵĴдϱ*/
//			for(j = 0; j < TouchPoint; j++){
//			 if(tp_dev.last_id[i] == tp_dev.tp_id[j]){
//			    flag = 1;
//			    break;
//			 }
//			}
//			if(flag == 0){
//			tp_dev.tp_sta[tempPoint] = 0x06;
//			if(tp_dev.last_id[i] > 0x0A){
//			  //printf("free err\r\r\n");
//			  return 0;
//			}
//			tp_dev.tp_id[tempPoint] = tp_dev.last_id[i];
//			tp_dev.x[tempPoint] = tp_dev.last_x[i];
//			tp_dev.y[tempPoint] = tp_dev.last_y[i];
//			tempPoint++;
//			//printf("free tp_id[%d] = %d\r\r\n",tempPoint,tp_dev.tp_id[tempPoint]);
//			} 
//          flag = 0;
//        }
//        MulTouch_Send(&tp_dev.x[TouchPoint],&tp_dev.y[TouchPoint],&tp_dev.tp_sta[TouchPoint],&tp_dev.tp_id[TouchPoint],tempPoint-TouchPoint);
//        for(i =0; i < TouchPoint; i++){
//          tp_dev.last_sta[i] =  tp_dev.tp_sta[i];
//          tp_dev.last_id[i] =  tp_dev.tp_id[i];
//          tp_dev.last_x[i] =  tp_dev.x[i];
//          tp_dev.last_y[i] =  tp_dev.y[i];
//        }
//        //MulTouch_Send(&tp_dev.x[TouchPoint],&tp_dev.y[TouchPoint],&tp_dev.tp_sta[TouchPoint],&tp_dev.tp_id[tempPoint],(tempPoint - TouchPoint));
//        lastPoint = TouchPoint;
//        return TouchPoint;
//      }else{/*һαȽϷִûб٣ϴ*/
//        for(i =0; i < TouchPoint; i++){
//          if(tp_dev.tp_id[i]> 0x0A){
//            //printf("errrrr\r\r\n");
//            return 0;
//          }
//          tp_dev.last_sta[i] =  tp_dev.tp_sta[i];
//          tp_dev.last_id[i] =  tp_dev.tp_id[i];
//          tp_dev.last_x[i] =  tp_dev.x[i];
//          tp_dev.last_y[i] =  tp_dev.y[i];
//        }
//        lastPoint = TouchPoint;
//        return TouchPoint;
//      }

//	goto END;

CLR_POINT:	
OUT_PROCESS:	
END:	
	buf[0] = 0xD0;
	buf[1] = 0x00;
	buf[2] = 0xAB;
	ret = cst3xx_i2c_write( buf, 3);
	if (ret < 0) {
		printf(" linc send read touch info ending failed.\r\n"); 
		cst3xx_reset_ic(20);
	}
	if(cnt>0) return 1;
	return 0;
}
#endif

static void cst3xx_ClearCMD(){
	u8 ret;
	u8 tempbuf[3];
	tempbuf[0] = 0xD0;
	tempbuf[1] = 0x00;
	tempbuf[2] = 0xAB;
	ret = cst3xx_i2c_write( tempbuf, 3);
	if (ret < 0) {
		printf(" linc send read touch info ending failed.\r\n"); 
		cst3xx_reset_ic(20);
	}
}


u8 TouchBuf[61]={0};
u8 HYN_CST148_Scan(void){
	unsigned char finger_id, sw;
	unsigned int  input_x = 0; 
	unsigned int  input_y = 0; 
	unsigned int  input_w = 0;
	int i2c_len;
  u8 ret = 0;
  u8 TouchPoint = 0;
  u8 tempPoint = 0;
  u8 i = 0;
  u8 j = 0;
  u8 temp = 0;
  u8 temp_id = 0;
  u8 flag = 0;
  u8 temp_sta = 0x06;
	int sum1 = 0, sum2 = 0;
	u8 offset = 0;
	printf(" linc send read touch info enter\r\n");
	TouchBuf[0] = 0xD0;
	TouchBuf[1] = 0x00;
	ret = cst3xx_i2c_read_register( TouchBuf, 7);
	if(TouchBuf[0] == 0xAB){
		cst3xx_ClearCMD();//ͬ,дD0 00 AB
		return 0;
	}
	TouchPoint = TouchBuf[5]&0x0F;
	if(TouchPoint == 1){
		//cst3xx_ClearCMD();
		TouchBuf[5] = 0xD0;
		TouchBuf[6] = 0x07;
		cst3xx_i2c_read_register( &TouchBuf[5], 2);
		sum1=TouchBuf[5] << 8|TouchBuf [6];
	} else if (TouchPoint > 1){
		TouchBuf[5] = 0xD0;
		TouchBuf[6] = 0x07;
		cst3xx_i2c_read_register( &TouchBuf[5], 5*(TouchPoint - 1)+3);
		sum1=TouchBuf[5*TouchPoint+1] << 8|TouchBuf[5*TouchPoint+2];
	}
	cst3xx_ClearCMD();//ͬдD0 00 AB
	for(j ;j < 5*TouchPoint;j++){
		sum2+=TouchBuf[j];
	}
	if(sum1 != sum2) TouchPoint=0;
	printf(" linc send read touch info point:%d.\r\n",TouchPoint); 
	if(TouchPoint > 0){
		for(i = 0; i < TouchPoint; i++){
			if(i == 0){
				offset = 0;
			}else{
				offset = 4;
			}
			tp_dev.tp_id[i] = (TouchBuf[i*5+offset]>>4) & 0x0F;
			tp_dev.tp_sta[i] = TouchBuf[i*5+offset] & 0x0F;
			if(tp_dev.tp_sta[i] == 0x06){//
				tp_dev.tp_sta[i] = 0x07;
			}else{
				tp_dev.tp_sta[i] = 0x06;
			}
			input_x = (unsigned int)((TouchBuf[i*5 + 1 + offset] << 4) | ((TouchBuf[i*5 + 3 + offset] >> 4) & 0x0F));
			input_y = (unsigned int)((TouchBuf[i*5 + 2 + offset] << 4) | (TouchBuf[i*5 + 3 + offset] & 0x0F));	
			input_w = (unsigned int)(TouchBuf[i + 4 + offset]);
			tp_dev.x[i] = (720-(u16)input_x) * 4095/720;
			tp_dev.y[i] = (1280-(u16)input_y)* 4095/1280;
		}
	}else{//TouchPoint = 0;ͷŰµĵ
		TouchPoint = 1;
		tp_dev.tp_id[0] = (TouchBuf[0]>>4) & 0x0F;
		tp_dev.tp_sta[0] = 0x06;
		input_x = (unsigned int)((TouchBuf[0*5 + 1] << 4) | ((TouchBuf[0*5 + 3] >> 4) & 0x0F));
		input_y = (unsigned int)((TouchBuf[0*5 + 2] << 4) | (TouchBuf[0*5 + 3] & 0x0F));	
		input_w = (unsigned int)(TouchBuf[0 + 4]);
		tp_dev.x[0] = (720-(u16)input_x) * 4095/720;
		tp_dev.y[0] = (1280-(u16)input_y)* 4095/1280;
	}
	
	/*
	if(TouchPoint == 0x00){
		printf("{[%d, %d, %d, %d]}\r\n",tp_dev.tp_id[0],tp_dev.tp_sta[0],tp_dev.x[0],tp_dev.y[0]);
	}else{
		printf("{");
		for(i = 0; i < TouchPoint; i++){
			printf("[%d, %d, %d, %d],",tp_dev.tp_id[i],tp_dev.tp_sta[i],tp_dev.x[i],tp_dev.y[i]);
		}
		printf("}\r\n");
	}*/
	return TouchPoint;
}

u8 HYN_CST148_Init(void)
{
	printf("HYN_CST148_Init. \r\r\n");
	while(1){
		GPIO_InitTypeDef  GPIO_InitStructure;	
		RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOB,ENABLE);//ʹPB˿ʱ

		GPIO_InitStructure.GPIO_Pin =GPIO_Pin_0|GPIO_Pin_1;// PB0PB1˿
		GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;	//
		GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
		GPIO_Init(GPIOB, &GPIO_InitStructure);
		GPIO_SetBits(GPIOB,GPIO_Pin_0);						//1
		GPIO_SetBits(GPIOB,GPIO_Pin_1);					//1

		CT_IIC_Init();      	//ʼI2C  
		HYN_RST=0;				//λ
		delay_ms(10);
		HYN_RST=1;				//ͷŸλ 
		delay_ms(10);
		
		GPIO_InitStructure.GPIO_Pin=GPIO_Pin_1;			//PC1˿
		GPIO_InitStructure.GPIO_Mode=GPIO_Mode_IPD;		//
		GPIO_Init(GPIOB, &GPIO_InitStructure);			//PC1
		GPIO_ResetBits(GPIOB,GPIO_Pin_1);				//	
		delay_ms(100);
		
		
//		cst3xx_boot_update_fw(pcst3xx_update_firmware);
		printf("HYN_CST148_Init donne \r\r\n");
		break;
	}

	return 1; 

}



u8 FT3517U_WR_Reg(u16 reg,u8 *buf,u8 len)
{
	u8 i;
	u8 ret=0;
	CT_IIC_Start();	 
	CT_IIC_Send_Byte(FT_CMD_WR);	//д 	 
	CT_IIC_Wait_Ack(); 	 										  		   
	CT_IIC_Send_Byte(reg&0XFF);   	//͵8λַ
	CT_IIC_Wait_Ack();  
	for(i=0;i<len;i++)
	{	   
    	CT_IIC_Send_Byte(buf[i]);  	//
		ret=CT_IIC_Wait_Ack();
		if(ret)break;  
	}
    CT_IIC_Stop();					//һֹͣ	    
	return ret; 
}

//GT1151һ
//reg:ʼĴַ
//buf:ݻ
//len:ݳ	

u8 FT3517U_RD_Reg(u16 reg,u8 *buf,u8 len)
{
	u8 i,ret; 
 	CT_IIC_Start();	
 	CT_IIC_Send_Byte(FT_CMD_WR);   //д 	 
	ret = CT_IIC_Wait_Ack();
 	CT_IIC_Send_Byte(reg&0XFF);   	//͵8λַ
	ret = CT_IIC_Wait_Ack();  
 	CT_IIC_Start();  	 	   
	CT_IIC_Send_Byte(FT_CMD_RD);   //Ͷ		   
	ret = CT_IIC_Wait_Ack();	   
	for(i=0;i<len;i++)
	{	   
    	buf[i]=CT_IIC_Read_Byte(i==(len-1)?0:1); //	  
	} 
    CT_IIC_Stop();//һֹͣ 
  return ret;
} 


u8 FT3517U_Init(void)
{
	u8 temp[5];
	//u8 myret = 0;
	//u8 temp1[239]; 
  printf("FT3517U_Init\r\r\n");
	while(1){
		GPIO_InitTypeDef  GPIO_InitStructure;	
		RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOB,ENABLE);//ʹPB˿ʱ

		GPIO_InitStructure.GPIO_Pin =GPIO_Pin_0|GPIO_Pin_1;// PB0PB1˿
		GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;	//
		GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
		GPIO_Init(GPIOB, &GPIO_InitStructure);
		GPIO_SetBits(GPIOB,GPIO_Pin_0);						//1
		GPIO_SetBits(GPIOB,GPIO_Pin_1);					//1

		CT_IIC_Init();      	//ʼI2C  
		FT_RST=0;				//λ
		delay_ms(10);
		FT_RST=1;				//ͷŸλ 
		delay_ms(10);
		
		GPIO_InitStructure.GPIO_Pin=GPIO_Pin_1;			//PC1˿
		GPIO_InitStructure.GPIO_Mode=GPIO_Mode_IPD;		//
		GPIO_Init(GPIOB, &GPIO_InitStructure);			//PC1
		GPIO_ResetBits(GPIOB,GPIO_Pin_1);				//	
		delay_ms(100);
		temp[0] = 0;
	  //ȡ汾ţοֵ0x3003
	  FT5206_WR_Reg(FT_DEVIDE_MODE,temp,1);	//ģʽ 
	  FT5206_WR_Reg(FT_ID_G_MODE,temp,1);		//ѯģʽ 
	  temp[0]=22;								//Чֵ22ԽСԽ	
	  FT5206_WR_Reg(FT_ID_G_THGROUP,temp,1);	//ôЧֵ
	  temp[0]=12;								//ڣС1214
	  FT5206_WR_Reg(FT_ID_G_PERIODACTIVE,temp,1); 
	  //ȡ汾ţοֵ0x3003
	  FT5206_RD_Reg(FT_ID_G_LIB_VERSION,&temp[0],2);
		if((((u16)temp[0]<<8)+temp[1]) == 0x01){//汾Ϊ0x01
      temp[0] = 0;
      temp[2] = 0;
			return 0;
		}
		//printf("CTP ID:%x\r\r\n",((u16)temp[0]<<8)+temp[1]);		
		/*
	  if(temp[0]==0X30&&temp[1]==0X03)//汾:0X3003
	  { 
		  printf("CTP ID:%x\r\r\n",((u16)temp[0]<<8)+temp[1]);
		  return 0;
	  } */
	}
	return 1;
}
const u16 FT3517U_TPX_TBL[10]={FT_TP1_REG,FT_TP2_REG,FT_TP3_REG,FT_TP4_REG,FT_TP5_REG,FT_TP6_REG,FT_TP7_REG,FT_TP8_REG,FT_TP9_REG,FT_TP10_REG};
#if 0
u8 TouchBuf[61]={0};
//u8 lastPoint = 0;
u8 FT3517U_Scan(void){
  u8 ret = 0;
  u8 TouchPoint = 0;
  u8 tempPoint = 0;
  u8 i = 0;
  u8 j = 0;
  u8 temp = 0;
  u8 temp_id = 0;
  u8 flag = 0;
  u8 temp_sta = 0x06;
  ret = FT3517U_RD_Reg(FT_REG_NUM_FINGER,TouchBuf,61);
  if(ret == 1){
    for(i = 0; i < 61 ;i++){
      TouchBuf[i] = 0x00;
    }
    FT3517U_Init();
    return 0;
  }
  if(TouchBuf[0] == 0xFF){
    return 0;
  }else{
    TouchPoint = TouchBuf[0]&0x0F;
    if(TouchPoint < 0x0B){
      for(i =0; i < TouchPoint; i++){/*ѵǰмȴ*/
        tp_dev.tp_sta[i] = ((TouchBuf[1+6*i]&0xC0)>>6);
        if(tp_dev.tp_sta[i] > 0x02){
          return 0; 
        }
        tp_dev.tp_id[i] = (TouchBuf[3+6*i]&0xF0)>>4;
        if(tp_dev.tp_id[i] > 0x0A){
          return 0;
        }
        tp_dev.x[i] = (1080-(u16)(((u16)(TouchBuf[1+6*i]&0x0F)<<8)|TouchBuf[2+6*i])) * 4095/1080;//0~1080
        tp_dev.y[i] = (1920-(u16)(((u16)(TouchBuf[3+6*i]&0x0F)<<8)|TouchBuf[4+6*i]))* 4095/1920;//0~1920
        if(tp_dev.x[i] > 4095 || tp_dev.x[i] < 0){
          tp_dev.x[i] = 0x00;
          //return 0;
        }
        if(tp_dev.y[i] > 4095 || tp_dev.y[i] < 0){
          tp_dev.y[i] = 0x00;
          //return 0;
        }
        //printf("tp_dev.tp_sta[%d]=0x%X\r\r\n",i,tp_dev.tp_sta[i]);
        //printf("tp_dev.tp_id[%d]=0x%X\r\r\n",i,tp_dev.tp_id[i]);
        if(tp_dev.tp_sta[i] == 0x00){//put down
          tp_dev.tp_sta[i] = 0x07;
        }else if(tp_dev.tp_sta[i] == 0x01){//put up
          tp_dev.tp_sta[i] = 0x06;
        }else if(tp_dev.tp_sta[i] == 0x02){//Contact
          tp_dev.tp_sta[i] = 0x07;
        }else{//err
          tp_dev.tp_sta[i] = 0x07;
        }
      }
      if(lastPoint > TouchPoint){/*һδȽϷд㱻ͷ*/
        if(TouchPoint == 0){
          for(i = 0; i < lastPoint; i++){
            tp_dev.tp_sta[i] = 0x06;
            tp_dev.tp_id[i] = tp_dev.last_id[i];
            tp_dev.x[i] = tp_dev.last_x[i];
            tp_dev.y[i] = tp_dev.last_y[i];
          }
          MulTouch_Send(tp_dev.x,tp_dev.y,tp_dev.tp_sta,tp_dev.tp_id,lastPoint);
          lastPoint = TouchPoint;
          return 0;
        }
        tempPoint = TouchPoint;
        //printf("lastPoint=%d\r\r\n",lastPoint);
        //printf("TouchPoint=%d\r\r\n",TouchPoint);
        for(i = 0; i < lastPoint; i++){/*ѰҳͷŵĴ㡣ͷŵĴдϱ*/
          for(j = 0; j < TouchPoint; j++){
             if(tp_dev.last_id[i] == tp_dev.tp_id[j]){
                flag = 1;
                break;
             }
          }
          if(flag == 0){
            tp_dev.tp_sta[tempPoint] = 0x06;
            if(tp_dev.last_id[i] > 0x0A){
              //printf("free err\r\r\n");
              return 0;
            }
            tp_dev.tp_id[tempPoint] = tp_dev.last_id[i];
            tp_dev.x[tempPoint] = tp_dev.last_x[i];
            tp_dev.y[tempPoint] = tp_dev.last_y[i];
            tempPoint++;
            //printf("free tp_id[%d] = %d\r\r\n",tempPoint,tp_dev.tp_id[tempPoint]);
          } 
          flag = 0;
        }
        MulTouch_Send(&tp_dev.x[TouchPoint],&tp_dev.y[TouchPoint],&tp_dev.tp_sta[TouchPoint],&tp_dev.tp_id[TouchPoint],tempPoint-TouchPoint);
        for(i =0; i < TouchPoint; i++){
          tp_dev.last_sta[i] =  tp_dev.tp_sta[i];
          tp_dev.last_id[i] =  tp_dev.tp_id[i];
          tp_dev.last_x[i] =  tp_dev.x[i];
          tp_dev.last_y[i] =  tp_dev.y[i];
        }
        //MulTouch_Send(&tp_dev.x[TouchPoint],&tp_dev.y[TouchPoint],&tp_dev.tp_sta[TouchPoint],&tp_dev.tp_id[tempPoint],(tempPoint - TouchPoint));
        lastPoint = TouchPoint;
        return TouchPoint;
      }else{/*һαȽϷִûб٣ϴ*/
        for(i =0; i < TouchPoint; i++){
          if(tp_dev.tp_id[i]> 0x0A){
            //printf("errrrr\r\r\n");
            return 0;
          }
          tp_dev.last_sta[i] =  tp_dev.tp_sta[i];
          tp_dev.last_id[i] =  tp_dev.tp_id[i];
          tp_dev.last_x[i] =  tp_dev.x[i];
          tp_dev.last_y[i] =  tp_dev.y[i];
        }
        lastPoint = TouchPoint;
        return TouchPoint;
      }
    }else{
      for(i = 0; i < 61 ;i++){
        TouchBuf[i] = 0x00;
      }
      return 0;
      
    }
    return 0;
  }
  return 0;
}
#endif
#if 0
u8 FT3517U_Scan(void)
{
	u8 buf[4]={0};
	u8 i=0;
	u8 temp = 0;
	u8 num = 0;
	u16 x = 0,y = 0;
  u8 ret = 0;
	static u8 t=0;//Ʋѯ,ӶCPUռ   
	t++;
	if((t%10)==0||t<10)//ʱ,ÿ10CTP_Scanż1,ӶʡCPUʹ
	{
		ret = FT3517U_RD_Reg(FT_REG_NUM_FINGER,&num,1);//ȡ״̬ 
    if(ret){
      printf("init\r\r\n");
      //FT3517U_Init();
      //printf("init OK\r\r\n");
    }else{
      if(num == 255 || num > 0x0B){
        t = 0;
        return 0;
      }
      if((num&0XF)&&((num&0XF)<0x0B))
      {
        temp=0XFF<<(num&0XF);
        tp_dev.sta=(~temp)|TP_PRES_DOWN|TP_CATH_PRES; 
        printf("num=%d\r\r\n",num);
        for(i =0; i< num; i++)
        {
          if(tp_dev.sta&(1<<i))
          {
            ret = FT3517U_RD_Reg(FT3517U_TPX_TBL[i],buf,4);
            if(ret){
              printf("s err\r\r\n");
              num = 0;
            }else{
              printf("buf[0]=0x%X",buf[0]);
              if((buf[0]&0xC0) == 0x00){
                tp_dev.tp_sta[i] = 0x06;
              }else{
                tp_dev.tp_sta[i] = 0x07;
              }
              tp_dev.tp_id[i] = ((buf[2]&0xF0)>>4);
              y = (1080-(((u16)(buf[0]&0X0F)<<8)+buf[1]));
              x = (1920-(((u16)(buf[2]&0X0F)<<8)+buf[3]));
              if((x == 0) && (y == 0)){
              }else if((x > 1920) || (y > 1080)){
              }else if(x < 0 || y < 0){
                printf("x< 0 || y<0\r\r\n");
              }else{
                tp_dev.y[i] = y;
                tp_dev.x[i] = x;
              }
            }
          }
          /*else{
            printf("tp_dev.sta&(1<<i)=0x%X\r\r\n",tp_dev.sta&(1<<i));
            printf("i = 0x%X\r\r\n",i);
          }*/
        }
      }else{
        num = 0;
      }
    }

		if(tp_dev.x[0]==0 && tp_dev.y[0]==0)num=0;
		t=0;
		
	}
	if((num&0X1F)==0)//޴㰴
	{
		if(tp_dev.sta&TP_PRES_DOWN)
		{
			tp_dev.sta&=~(1<<7);
		}else{
			//tp_dev.x[0]=0xffff;
			//tp_dev.y[0]=0xffff;
			tp_dev.sta&=0XE0;	//Ч	
		}
			
	}
  if(t>240)t=10;//´10ʼ
	return num;
	
}
#endif
