# Write to new users

- This page provides a quick diagnosis of whether the hardware is normal. The firmware in the example table below provides quick testing of the hardware. Please follow the steps below to test

# 1️⃣ Quickly diagnose hardware

| Product                 | Firmware Name                             |
| ----------------------- | ----------------------------------------- |
| [T-Display-S3][1]       | [ScreenDetection](./ScreenDetection.bin)  |
| [T-Display-S3][1]       | [Factory](./firmware_no_touch.bin)        |
| [T-Display-S3-Touch][2] | [Factory](./firmware_touch.bin)           |
| [T-Display-S3-MIDI][3]  | [firmware](./T-Display-S3-MIDI_firmware/) |

[1]: https://www.lilygo.cc/products/t-display-s3?variant=42589373268149
[2]: https://www.lilygo.cc/products/t-display-s3?variant=42351558590645
[3]: https://www.lilygo.cc/products/t-display-s3?variant=43164741632181

**ScreenDetection**
After ScreenDetection is written, open the ArduinoIDE or PlatformIO serial monitor, and then press RST (the button on the side of T-Display-S3). The serial monitor should automatically reconnect and print out the relevant screen information. .If all the information is normal but the screen still does not display, you can determine that the screen is damaged.
![](./images/log.png)


### Use ESP Download Tool

- Download [Flash_download_tool](https://www.espressif.com.cn/sites/default/files/tools/flash_download_tool_3.9.5_0.zip)

![web_flasher](./images/esp_downloader.gif)

* Note that after writing is completed, you need to press RST to reset.


### Use Web Flasher

- [ESP Web Flasher Online](https://espressif.github.io/esptool-js/)

![web_flasher](./images/web_flasher.gif)

* Note that after writing is completed, you need to press RST to reset.

### Use command line


If system asks about install Developer Tools, do it.

```
python3 -m pip install --upgrade pip
python3 -m pip install esptool
```

In order to launch esptool.py, exec directly with this:

```
python3 -m esptool
```

For ESP32-S3 use the following command to write

```
esptool --chip esp32s3  --baud 921600 --before default_reset --after hard_reset write_flash -z --flash_mode dio --flash_freq 80m 0x0 firmware.bin

```

# 2️⃣FAQ

- Can't upload any sketch，Please enter the upload mode manually.
   1. Connect the board via the USB cable
   2. Press and hold the **BOOT** button , While still pressing the **BOOT** button (If there is no **BOOT** button, you need to use wires to connect **GND** and **IO0** together.)
   3. Press **RST** button
   4. Release the **RST** button
   5. Release the **BOOT** button (If there is no **BOOT** button, disconnect IO0 from GND.)
   6. Upload sketch
   7. Press the **RST** button to exit download mode


