#define CONFIG_FREERTOS_HZ 1000
SemaphoreHandle_t myFirstSem;

#define MUTEX

void t1(void* parameter) {
  for (;;) {
#ifdef MUTEX
    if (xSemaphoreTake(myFirstSem, (TickType_t)1000) == pdTRUE) {
      // yep got it
      Serial.print("ABCDEFGHIJKLMNOPQRST\n");
      xSemaphoreGive(myFirstSem);
    }
#else
    Serial.print("ABCDEFGHIJKLMNOPQRST\n");  // no mutex
#endif
  }
}

void t2(void* parameter) {
  for (;;) {
#ifdef MUTEX
    if (xSemaphoreTake(myFirstSem, (TickType_t)1000) == pdTRUE) {
      // yep got it
      Serial.print("abcdefghijklmnopqrst\n");
      xSemaphoreGive(myFirstSem);
    }
  }
#else
    Serial.print("abcdefghijklmnopqrst\n");
#endif
}

void setup() {
  Serial.begin(112500);
  vTaskDelay(1000/portTICK_PERIOD_MS);

#ifdef MUTEX
  // create sem before you start tasks
  myFirstSem = xSemaphoreCreateMutex();  // 1 key present
#endif

  vTaskPrioritySet(NULL, 10);  // so it dont loose cpu

  xTaskCreate(t1, "t1", 10000, NULL, 2, NULL);
  xTaskCreate(t2, "t1", 10000, NULL, 2, NULL);
  Serial.println("just bef");
 
  vTaskDelete(NULL);  // main or loop quit
}

void loop() {}
