

#define CONFIG_FREERTOS_HZ 1000

SemaphoreHandle_t syncSem;

 TimerHandle_t sampler1;

#define configTIMER_SERVICE_TASK_NAME "Tmr Svc"
#define configTIMER_TASK_PRIORITY (configMAX_PRIORITIES - 1)
#define configTIMER_TASK_STACK_DEPTH (configMINIMAL_STACK_SIZE * 2)

volatile int cci = 0;


void t1(void* parameter) {

  for (;;) {
    if (xSemaphoreTake(syncSem, (TickType_t)1000) == pdTRUE) {
      // yep got it
      Serial.print("got intr");
      Serial.println(cci);
  
    }

  }
}

void samplerCode(xTimerHandle pxTimer) {

   xSemaphoreGive(syncSem);
}

void setup() {
  Serial.begin(115200);

 vTaskDelay(1000/ portTICK_PERIOD_MS);

  sampler1 = xTimerCreate(
    "sampler1",
    pdMS_TO_TICKS(1000), /* period/time */
    pdTRUE,              /* auto reload */
    (void*)0,            /* timer ID */
    samplerCode);        /* callback */


  vTaskPrioritySet(NULL, 10);  // so it dont loose cpu

  syncSem =  xSemaphoreCreateCounting(100,0); // 1 key present


  xTaskCreate(t1, "t1", 10000, NULL, 1, NULL);
  xTimerStart(sampler1, 0);  // start regular timer

  vTaskDelete(NULL);
}

void loop() {
}
