// https://microcontrollerslab.com/freertos-recursive-mutex-avoid-deadlocks-examples-arduino/

#define CONFIG_FREERTOS_HZ 1000

SemaphoreHandle_t mutSem;

void t1( void * parameter )
{
  for (;;)
  {
    if ( xSemaphoreTake(mutSem, (TickType_t)1000)  == pdTRUE )   {
      // yep got the access key - finally :-)
      // your code or data to be protected

      xSemaphoreGive(mutSem );  // give back access key
    }
    else {
      // did not get critical region
    }
  }
}

void setup()
{

  // mutex and binary semaphore is equal - except for mutex do support task priority inheritance
  mutSem = xSemaphoreCreateMutex(); 
  // or
  mutSem = xSemaphoreCreateBinary();
  // or
  mutSem = xSemaphoreCreateCounting(1, 1); //max count , inital count (1: for critical region use)

  xTaskCreatePinnedToCore(t1, "t1", 2000, NULL,  2, NULL, 0);


  vTaskDelete(NULL);  // suicide
}

void loop()
{

}
