// JDN 2021
// rt-esp32-fifobuffer01

// A buffersystem to be put in between an ISR and your code
//
// aka ringbuffe or cyclic buffer

// OUR DATA
const int BUFSZ = 50;  //

// buffer with buffer elements of integer type
uint32_t cyclicBuf[BUFSZ]; // the buffer where we receive data from ISR

volatile int rdIndex = 0, wrIndex = 0, nrInBuf = 0, overFlowCnt = 0;


//-- two variants of writing to buf

// save in buf if space
// if no space just drop saving
// == you loose newest data
// return 0: ok, -1: data drop no saving

void bufInit()
{
  rdIndex = wrIndex = nrInBuf = overFlowCnt = 0;
}

int bufPutDrop(int sampleVal)  // to be called from ISR
{
  if (BUFSZ <= nrInBuf ) { // vacancy ?
    overFlowCnt++;
    return -1;      // nope
  }

  nrInBuf++;        // another on in buf
  wrIndex++;        // where to write element in buffer
  wrIndex %= BUFSZ; // wrap around if end of buf:.. 1%5 = 1  4%5 = 4  5%5 = 0

  cyclicBuf[wrIndex] = sampleVal;
  return 0;         // ok
}


// save in buf if space
// if no space just overWrite oldest elm
// return 0: ok, -1: ok, buf buffer overwrite == loosing oldest data

int bufPutOverWrite(int sampleVal) {  // to be called from ISR
  int retV = 0;
  wrIndex++;   // find location to write
  wrIndex %= BUFSZ;  // wrap around if end of buf:.. 1%5 = 1  4%5 = 4  5%5 = 0

  if (wrIndex == rdIndex)  { // we are full
    rdIndex++;      // push read index in front of write index
    rdIndex %= BUFSZ;
    overFlowCnt++;       // we did overwrite an item
    retV = -1;
  }
  else {
    nrInBuf++;
  }
  cyclicBuf[wrIndex] = sampleVal;
  return retV;
}

// get elm from buf
// return 0: ok, -1: no elements, positive: ok but value is number of elements overwritten since last call
int bufGet(int *v) {
  int of;
  if (nrInBuf <= 0) {
    return -1; // no elements in buffer
  }

  *v = cyclicBuf[rdIndex];  // get element

  rdIndex++;      // read index for next time
  rdIndex %= BUFSZ;
  nrInBuf--;

  of = overFlowCnt;
  overFlowCnt = 0;  // reset
  return of;
}


void setup() {
  Serial.begin(115200);
  delay(2000);
}

int cc=0;
void loop() {
  int  v2;
  int err;
  err = bufPutDrop(cc);

  // put 2 in buf every time I get 1  --> overflow bq I use Drop !
  if (err < 0) 
    Serial.println("bufPutDrop err");
  err = bufPutDrop(cc);
  if (err < 0) 
    Serial.println("bufPutDrop err2");
    
  cc++;
  
  err = bufGet(&v2);
  if (err != 0) 
    Serial.println("bufPutDrop err");

  Serial.println(v2);
  delay(100);
}
