// https://www.freertos.org/a00116.html
/*
   JDN
   queues  - FreeRTOS
*/

QueueHandle_t xQueue;

struct AMessage
{
  char ucMessageID;
  char ucData;
};

int mySharedData = 0;

void t1(void *p)
{
  static struct AMessage msg = {1, 1};
  while (1) {

    msg.ucData++;
    if (pdPASS == xQueueSend(xQueue, (void *)&msg, 100) ) {  // wait max 100 tick if buffer is full
        // yes we got it send
    }
    vTaskDelay(200); 
  }
}


void t2(void *p)
{
  while (1) {
    vTaskDelay(200);  // just to keep program alive
  }
}

void setup() {
  Serial.begin(115200);

  xQueue = xQueueCreate( 10, sizeof( struct AMessage) );

  xTaskCreatePinnedToCore(t1, "t1", 2000, NULL,  2, NULL, 0);
  xTaskCreatePinnedToCore(t2, "t2", 2000, NULL,  2, NULL, 0);
  vTaskDelete(NULL);
}


void loop() {}
