// https://techtutorialsx.com/2017/10/07/esp32-arduino-timer-interrupts/

// https://docs.espressif.com/projects/esp-idf/en/latest/esp32/api-guides/freertos-smp.html


// JDN 2021

//CONFIG TIMER SPEED
const int timerMicroSecCount = 1000000;  // 1e6 = 1 sec


volatile int interruptCounter;
int totalInterruptCounter;

hw_timer_t * timer = NULL;
portMUX_TYPE timerMux = portMUX_INITIALIZER_UNLOCKED;

void IRAM_ATTR onTimer() {
  portENTER_CRITICAL_ISR(&timerMux); // for dataprotection on dual core
  interruptCounter++;
  portEXIT_CRITICAL_ISR(&timerMux);

}


void startCyclicTimerISR()
{

  timer = timerBegin(0, 80, true);
  timerAttachInterrupt(timer, &onTimer, true);
  timerAlarmWrite(timer, timerMicroSecCount, true);
  timerAlarmEnable(timer);
}


void setup() {

  Serial.begin(115200);
  delay(2000);
  
  startCyclicTimerISR();
}

void loop() {

  if (interruptCounter > 0) {

    portENTER_CRITICAL(&timerMux);
    interruptCounter--;
    portEXIT_CRITICAL(&timerMux);

    totalInterruptCounter++;

    Serial.print("An interrupt as occurred. Total number: ");
    Serial.println(totalInterruptCounter);

  }
}
