
SemaphoreHandle_t syncSem;
QueueHandle_t  msgQ;

int  interruptPin = 23;

volatile int rcvCnt = 0;

void IRAM_ATTR handleInterrupt() {
  xSemaphoreGiveFromISR(syncSem, NULL);
}


void t1( void * parameter )
{
  int i = 0;
  int res;
  for (;;)
  {
    if ( xSemaphoreTake(syncSem, (TickType_t)1000)  == pdTRUE )
    {
      i++;
      // yep got it
      res = xQueueSend(msgQ,  &i , 0 );// Send if space - dont wait for space !
      Serial.print("isr detected - signal received");

      if (res = pdTRUE) {
        Serial.print(" msg send: ");
        Serial.print(i);
      }
      else {
        Serial.print("msg not send - buf full ?");
      }
    }
    else {
      Serial.println("time out");
    }
    Serial.print("\nrtcv count: ");
    Serial.println(rcvCnt);
  }
}


void t2( void * parameter )
{
  int iii = 0;
  for (;;)
  {
    if (pdTRUE == xQueueReceive(msgQ, &iii, 100)) {
      // got it

      rcvCnt++;
    }
  }
}


void setup() {
  Serial.begin(115200);
  delay(2000);

  msgQ = xQueueCreate(10, sizeof(int));

  syncSem = xSemaphoreCreateBinary();

  xTaskCreate(t1, "t1", 10000, NULL,  2, NULL);
  xTaskCreate(t2, "t2", 10000, NULL,  3, NULL);

  pinMode(interruptPin, INPUT_PULLUP);
  attachInterrupt(digitalPinToInterrupt(interruptPin), handleInterrupt, FALLING);

  vTaskDelete(NULL); // terminate myself
}

void loop() {
}
