// https://www.freertos.org/a00116.html
/*
   JDN
   queues  - FreeRTOS
*/

QueueHandle_t Q1, Q2;

struct AMessage
{
  char ucMessageID;
  char ucData;
};


void t1(void *p)
{
  static struct AMessage mmm;
  while (1) {
    vTaskDelay(500);
    // NB man skal maaske have timeout her storre end eller lig Send loop tid
    if ( xQueueReceive( Q1,  &( mmm ), ( TickType_t ) 102 ) == pdTRUE )
    {
      while (pdTRUE != xQueueSend(Q2, (void *)&mmm, 700))  // loop fordi jeg ikke vil tabe beskedder. Den SKAL sendes
      {
      }
    }
    else {
      Serial.println("hm");
    }
  }
}


void t2(void *p)
{
  static struct AMessage mmm;
  while (1) {
    //vTaskDelay(500);
    // NB man skal maaske have timeout her storre end eller lig Send loop tid
    if ( xQueueReceive( Q2,  &( mmm ), ( TickType_t ) 102 ) == pdTRUE )
    {
      Serial.println(mmm.ucData); // debugging

      while (pdTRUE != xQueueSend(Q1, (void *)&mmm, 700))  // loop fordi jeg ikke vil tabe beskedder. Den SKAL sendes
      {
      }
    }
    else {
      Serial.println("hm");
    }
  }
}
void setup() {
  static struct AMessage mm;
  Serial.begin(115200);
  delay(1000);
  Serial.println("-----------");

  Q1 = xQueueCreate( 10, sizeof( struct AMessage) );
  Q2 = xQueueCreate( 10, sizeof( struct AMessage) );

  //fyld lidt beskedder i Q1 - 5 stk
  mm.ucData = 'a';
  for (int i = 0; i < 5; i++) {
    xQueueSend(Q1, (void *)&mm, 100);
    mm.ucData++;
  }

  xTaskCreatePinnedToCore(t1, "t1", 2000, NULL,  2, NULL, 0);
  xTaskCreatePinnedToCore(t2, "t2", 2000, NULL,  2, NULL, 0);
  vTaskDelay(100);
  vTaskDelete(NULL);
}


void loop() {}
