/* JDN
 *  
 *  Programmet viser hvordan man kan overfoere een parameter til entask
 *  freeRTOS forlange at parametertypen er  void * som det ses i task0
 *  Det betyder at man inde i ntasken skal lave en typecast for at faa
 *  den rigtige type frem som vi vil  have - her int*
 *  
 *  Man kan istedet flytte typecast til xTaskCreate kald 
 *  I task1 har parameteren den type vi vil have  int *, idet vi vil overfore
 *  en pointer til et heltal.
 *  Saa laegger vi istedet et typecast paa referencen til task1 i xTaskCreat kaldet
 *  (void (*)( void *))  
 *  xTaskCreatePinnedToCore((void (*)( void *))task1, "t1", 2000, &hemmelig2,  2, NULL, 0);
 *  
 *  Manbehobver ikke entypecast paa parameteren (&hemmelig2). men skal det vaere helt
 *  rent vurde man nok skrive   (void*)(&hemmelig2)
*/


void task0(void *pParm)
{
  int etTal;

  etTal  =  * ((int *)pParm);  // Vi maa type caste det her nu    "int * pParm"
  while (1) {
    Serial.println(etTal);
    vTaskDelay(100);
  }
}

void task1(int *pParm)  // her bruger vi en retvisende parametererklaering
{
  int etTal;

  etTal  =  *pParm;  
  while (1) {
    Serial.println(etTal);
    vTaskDelay(100);
  }
}

int hemmelig = 1234;
int hemmelig2 = 122234;

void setup() {
  Serial.begin(115200);
  delay(1000);
  vTaskDelay(1000);

  disableCore0WDT();

  xTaskCreatePinnedToCore(task0, "t0", 2000, &hemmelig,  2, NULL, 0);

  // her har vi en typecast paa funktionsnavnet saa det stemmer overens med FreeRTOS
  // (void (*)( void *)  laeses som:  (*)       pointer til funktion  
  //                                  (void *)  der har en parameter af pointer type  void *
  //                                   void     og ikke returner noget
  xTaskCreatePinnedToCore((void (*)( void *))task1, "t1", 2000, &hemmelig2,  2, NULL, 0);
  //void task0( void *pParm)
  //(void (*)( void *pParm))
  vTaskDelete(NULL);
}

void loop() {

}
