// rt-esp32-timeradc01
// https://techtutorialsx.com/2017/10/07/esp32-arduino-timer-interrupts/

// https://docs.espressif.com/projects/esp-idf/en/latest/esp32/api-guides/freertos-smp.html

// https://microcontrollerslab.com/freertos-counting-semaphore-examples-arduino/

// JDN 2021



// ISR
//--------------------------
// counting semaphore timed semaphore

const int prescale = 80000;  // 80 MHz  => 1 kHz

volatile int iCnt0 = 0, iCnt1 = 0, iCnt2 = 0, iCnt3 = 0;

hw_timer_t *timer0, *timer1, *timer2, *timer3;
SemaphoreHandle_t sem0, sem1, sem2, sem3;


// copy paste this function if more timer is needed . REMEMBER to change semID in line 26
void IRAM_ATTR onTimer0() {   // standard functinodeclaration + (!)   IRAM_ATTR which force compiler to place function in interal high speed RAM - for quick run of code

  xSemaphoreGiveFromISR( sem0, NULL);

  iCnt0++;   // I am alive :-)
}


hw_timer_t * timer = NULL;  // pointer to variable which hold ISR config info


hw_timer_t * createCyclicTimer(int timerNr, int count)
{
  hw_timer_t * timer = NULL;
  // create a timer entry on timer 0  (4 in total available: 0,1,2,3
  timer = timerBegin(timerNr,                 // timerNr
                     prescale,                // Prescaler config. 80 MHz prescaled (downscaled) with factor of 80 ->  1 MHz heartbeat/granularity on timer
                     true);             // true: count on rising edge, false: count on falling edge

  timerAlarmWrite(timer,                // which timer to configure
                  count,   // o of ticks for an interrupt. Remember 1 tick is 80 MHz/1000 ~  1 msec
                  true);                // true: auto reload

  return timer;
}




void task1(void *pParms)
{
  int tick = 0;
  Serial.println("c");
  vTaskDelay(300);
  Serial.println(iCnt0);
  while (1) {
    // vTaskDelay(300);
    Serial.println("d");
    //   while (xSemaphoreTake(sem0, 1000) != pdTRUE) ; // wait until I get it
    Serial.println("e");
    Serial.println(tick);
    tick++;
  }
}

void setup() {
  Serial.begin(115200);
  delay(2000);

  //xSemaphoreCreateCounting( UBaseType_t uxMaxCount, UBaseType_t uxInitialCount);
  sem0 = xSemaphoreCreateCounting(100, 0);
  sem1 = xSemaphoreCreateCounting(100, 0);
  sem2 = xSemaphoreCreateCounting(100, 0);
  sem3 = xSemaphoreCreateCounting(000, 0);


  Serial.println("a");
  // start a timer

 // timer0 =  createCyclicTimer(0, 1000); // timer 0 1000 millisec
  // timerAttachInterrupt(timer0,           // which timer to use - created just above
  //                      onTimer0,         // onTimer is the function that is called
  //                      true);           // true: reload timer after interrupt so it will run periodically (for sampling etc)
  //timerAlarmEnable(timer0);
  // ...
  xTaskCreatePinnedToCore(task1, "t1", 2000, NULL,  2, NULL, 0);
  // etc
  Serial.println("b");
}

void loop() {
  vTaskDelay(100);
}
