#include <Arduino_FreeRTOS.h>
#include <semphr.h>
//#define CONFIG_FREERTOS_HZ 1000


SemaphoreHandle_t xSerialSemaphore;

void t1( void * parameter )
{
  for (;;)
  {
    Serial.print("12345678901234567890\n");

    vTaskDelay(300 / portTICK_PERIOD_MS);
  }
}

void t2( void * parameter )
{
  for (;;)
  {
    Serial.println("kwack");
    vTaskDelay(100 / portTICK_PERIOD_MS);
  }
}

void t3( void * parameter )
{
  for (;;)
  {
    Serial.print("ABCDEFGHIJKLMNOPQRST\n");
    vTaskDelay(500 / portTICK_PERIOD_MS);
  }
}

void setup()
{
  if ( xSerialSemaphore == NULL )  // Check to confirm that the Serial Semaphore has not already been created.
  {
    xSerialSemaphore = xSemaphoreCreateMutex();  // Create a mutex semaphore we will use to manage the Serial Port
    if ( ( xSerialSemaphore ) != NULL )
      xSemaphoreGive( ( xSerialSemaphore ) );  // Make the Serial Port available for use, by "Giving" the Semaphore.
  }

  Serial.begin(115200);
  delay(3000);
  Serial.println(configMAX_PRIORITIES);
  xTaskCreate(t1, "t1", 100, NULL,  1, NULL); // NB 100 == 200 bytes ! bq word size is 2
  xTaskCreate(t2, "t1", 100, NULL,  1, NULL);
  xTaskCreate(t3, "t1", 100, NULL,  1, NULL);

}

void loop()
{
  //   must be empty in arduino world
}
