// rt-esp32-timeradc01
// https://techtutorialsx.com/2017/10/07/esp32-arduino-timer-interrupts/

// https://docs.espressif.com/projects/esp-idf/en/latest/esp32/api-guides/freertos-smp.html


// JDN 2021



// ISR
//--------------------------


volatile int iCnt = 0;

void IRAM_ATTR onTimer() {   // standard functinodeclaration + (!)   IRAM_ATTR which force compiler to place function in interal high speed RAM - for quick run of code
  static int sampleVal;

  // FAKE PART
  sampleVal = 4;  // in real life read ADC converter aka Arduino way  sampleVal = analogRead(3);

  iCnt++;   // I am alive :-)

}


hw_timer_t * timer = NULL;  // pointer to variable which hold ISR config info

const int timerMicroSecCount = 1000;  // 1e6 = 1 sec

void startCyclicTimerISR()
{
  // create a timer entry on timer 0  (4 in total available: 0,1,2,3
  timer = timerBegin(0,                 // timerNr
                     80,                // Prescaler config. 80 MHz prescaled (downscaled) with factor of 80 ->  1 MHz heartbeat/granularity on timer
                     true);             // true: count on rising edge, false: count on falling edge

  timerAlarmWrite(timer,                // which timer to configure
                  timerMicroSecCount,   // o of ticks for an interrupt. Remember 1 tick is 80 MHz/1000 ~  1 msec
                  true);                // true: auto reload

  timerAttachInterrupt(timer,           // which timer to use - created just above
                       onTimer,         // onTimer is the function that is called
                       true);           // true: reload timer after interrupt so it will run periodically (for sampling etc)
  
  timerAlarmEnable(timer);              // start gogo   . stop by timerAlarmDisable(timer);  NASTY : from which core ?
}


void setup() {
  Serial.begin(115200);
  delay(2000);

  startCyclicTimerISR();
  // herfter korer system med interrupt
}

void loop() {
  static volatile int iLive = 0;

  if (iLive != iCnt) { // check if there has been an Intr since last - if so print intr number
    iLive = iCnt;
    Serial.println(iLive);
  }
}
