// https://www.freertos.org/a00116.html
/*
   JDN
   queues  - FreeRTOS
*/

#define NRQ_ELM 10

struct myMsgTp {
  int sekvNr;
  int lostMsg;
  unsigned long tid;
};

QueueHandle_t Q1, Q2;

// QueueHandle_t Q1, Q2;
// <queueRef> = xQueueCreate( <nr elements>, sizeof( <msg> ) )

// xQueueReceive( <queue>,  &(<msg>), ( TickType_t ) <timeout> / portTICK_PERIOD_MS)
// xQueueSend(Q2, (void *)&mmm, <timeout>/ portTICK_PERIOD_MS)

//  xTaskCreatePinnedToCore(<function>, "<name>", <staksize>, <parameter / NULL>, <priority: 0:highest>, NULL, 0);

void t1(void *p)
{
  static int transNr = 0;
  struct myMsgTp tt;
  static int lost=0;
  while (1) {

    while (digitalRead(23) == HIGH) {
      vTaskDelay(1);
    }

    tt.tid = millis();
    tt.sekvNr = transNr; 
    tt.lostMsg=lost;
    transNr++;
    if (pdTRUE != xQueueSend(Q1, (void *)&tt, 100 / portTICK_PERIOD_MS))
    {
        lost++;
    }
    vTaskDelay(5); // primitiv debounce
  }
}

void t2(void *p)
{
  struct myMsgTp ttt; // en pointer hertil er af type (struct myMsgTp *)
  while (1) {
    while (pdTRUE != xQueueReceive(Q1, (void *) & (ttt), ( TickType_t ) (200 / portTICK_PERIOD_MS)) ) {}
    Serial.print(ttt.sekvNr); Serial.print(" lost:"); Serial.print(ttt.lostMsg); Serial.print(" "); Serial.println(ttt.tid);
    vTaskDelay(500);
  }

}

void setup() {
  struct myMsgTp tmp;
  Serial.begin(115200); vTaskDelay(1000);
  pinMode(LED_BUILTIN, OUTPUT);
  digitalWrite(LED_BUILTIN, LOW);
  pinMode(23, INPUT_PULLUP);

  Q1 = xQueueCreate(NRQ_ELM, sizeof(struct myMsgTp ) );

  xTaskCreatePinnedToCore(t1, "t1", 2000, NULL, 2, NULL, 0);
  xTaskCreatePinnedToCore(t2, "t2", 2000, NULL, 2 , NULL, 0);
  vTaskDelete(NULL);
}

void loop() {}
