// https://microcontrollerslab.com/freertos-recursive-mutex-avoid-deadlocks-examples-arduino/

// v2 ændret !=  til == i xSemaphoreTake kald

#define CONFIG_FREERTOS_HZ 1000

SemaphoreHandle_t syncSem;

/*
 * hvi man saetter timeout i Take kalkdet til tal storre end looptiden(vTaskDelay)
 * Saa vil vi se at vi ryger i timeout en gang imellem. Dvs vi TABER signaler/gogos !!!
 */
void t1( void * parameter )
{
  int i = 0;

  for (;;)
  {
    if ( xSemaphoreTake(syncSem, (TickType_t)300)  == pdTRUE )   {
      // test
      Serial.println(i++);       
    }
    else {
        Serial.println("did not get a kick :-( ");
    }
  }
}

void t2( void * parameter )
{
  for (;;)
  {
    xSemaphoreGive(syncSem);
    vTaskDelay(200);
  }
}


void setup()
{
  Serial.begin(115200);
  delay(1000);
  syncSem = xSemaphoreCreateCounting(6, 0); //max count , inital count (1: fpor critical region use

  xTaskCreatePinnedToCore(t1, "t1", 2000, NULL,  2, NULL, 0);
  xTaskCreatePinnedToCore(t2, "t2", 2000, NULL,  2, NULL, 0);


  vTaskDelete(NULL);  // suicide
}

void loop()
{

}
