// https://microcontrollerslab.com/freertos-recursive-mutex-avoid-deadlocks-examples-arduino/

#define CONFIG_FREERTOS_HZ 1000

SemaphoreHandle_t mutSem;

void t1( void * parameter )
{
  for (;;)
  {
    if ( xSemaphoreTake(mutSem, (TickType_t)1000)  == pdTRUE )   {
      Serial.print("1234");
      Serial.print("1234");
      Serial.print("1234");
      Serial.print("1234");
      Serial.print("1234");
      Serial.print("1234");
      Serial.print("1234");
      Serial.print("1234");
      Serial.print("1234");
      Serial.println("1234");
      xSemaphoreGive(mutSem);  // give back access key
    }
    else {
      // did not get critical region
    }
  }
}


void t2( void * parameter )
{
  for (;;)
  {
    if ( xSemaphoreTake(mutSem, (TickType_t)1000)  == pdTRUE )   {

      Serial.print("abcd");
      Serial.print("abcd");
      Serial.print("abcd");
      Serial.print("abcd");
      Serial.print("abcd");
      Serial.print("abcd");
      Serial.print("abcd");
      Serial.print("abcd");
      Serial.print("abcd");
      Serial.println("abcd");
      xSemaphoreGive(mutSem );  // give back access key
    }
    else {
      // did not get critical region
    }
  }
}
void setup()
{
  Serial.begin(115200);
  vTaskDelay(1000);
  // mutex and binary semaphore is equal - except for mutex do support task priority inheritance
  //mutSem = xSemaphoreCreateMutex();
  // or
  //mutSem = xSemaphoreCreateBinary();
  // or
  mutSem = xSemaphoreCreateCounting(2, 1); //max count , inital count (1: for critical region use)

  xTaskCreatePinnedToCore(t1, "t1", 2000, NULL,  2, NULL, 0);
  xTaskCreatePinnedToCore(t2, "t2", 2000, NULL,  2, NULL, 0);


  vTaskDelete(NULL);  // suicide
}

void loop()
{

}
