//#include "FS.h"
//#include "SD.h"
//#include "SPI.h"
//
//SPIClass SDSPI(HSPI);
//#define CS_SD       33
//#define SCLK_SD     25
//#define MISO_SD     27
//#define MOSI_SD     26

#define ARRAY_LENGTH 1000

// interrupt
volatile bool ISRflag;
int totalInterruptCounter;
hw_timer_t * timer = NULL;
portMUX_TYPE timerMux = portMUX_INITIALIZER_UNLOCKED;

SemaphoreHandle_t syncSem, writeSem;

int32_t ECG_bufferA[ARRAY_LENGTH];
int32_t ECG_bufferB[ARRAY_LENGTH];

//JDN
void IRAM_ATTR ISRtick() {

  static BaseType_t xHigherPriorityTaskWoken;

  xHigherPriorityTaskWoken = pdFALSE;
  xSemaphoreGiveFromISR(syncSem, &xHigherPriorityTaskWoken);  //kick sampler

  if (xHigherPriorityTaskWoken) {
    portYIELD_FROM_ISR();
  }
}


void startTimerISR() {
  timer = timerBegin(0, 80, true);
  //JDN  timerAttachInterrupt(timer, &onTimer, true);
  timerAttachInterrupt(timer, ISRtick, true);
  timerAlarmWrite(timer, 1000, true);
  timerAlarmEnable(timer);
}

void setup() {
  Serial.begin(115200);
  Serial.println(" Starting in 2 sec ... ");
  Serial.println("");
  delay(2000);

  SDSPI.begin(SCLK_SD, MISO_SD, MOSI_SD, CS_SD);

  if (!SD.begin(CS_SD, SDSPI)) {
    Serial.println("Card Mount Failed");
    return;
  }
  uint8_t cardType = SD.cardType();

  if (cardType == CARD_NONE) {
    Serial.println("No SD card attached");
    return;
  }

  float cardSize= (float) SD.cardSize() / (1024.0 * 1024.0 * 1024.0);
  Serial.printf("SD Card Size: %.1f GiB\n", cardSize);


  writeFile(SD, "/data_EKG.txt", " ");
  writeFile(SD, "/data_SKG.txt", " ");

  syncSem = xSemaphoreCreateBtinary();
  writeSem = xSemaphoreCreateBinary();
  xTaskCreatePinnedToCore(
    SampleDatacode, /* Function to implement the task */
    "SampleData", /* Name of the task */
    10000,  /* Stack size in words */
    NULL,  /* Task input parameter */
    1,  /* Priority of the task */
    NULL,  /* Task handle. */
    1); /* Core where the task should run */

  xTaskCreatePinnedToCore(
    writeBufferTask, /* Function to implement the task */
    "wrBuf", /* Name of the task */
    10000,  /* Stack size in words */
    NULL,  /* Task input parameter */
    1 + 1, /* Priority of the task */
    NULL,  /* Task handle. */
    1); /* Core where the task should run */


  startTimerISR();

}

void loop() {

}

// FUNCTIONS BELOW
int bufferToWrite;
// FreeRTOS tasks

void SampleDatacode(void * parameter) {
  int flag = 0;
  int index;
  index = 0;


  for (;;) {
    if ( xSemaphoreTake(syncSem, (TickType_t)1000)  == pdTRUE ) { // time for sampling ?
      //JDNwhile (ISRflag) {

      if (flag)
        ECG_bufferB[index] = analogRead(A0);
      else
        ECG_bufferA[index] = analogRead(A0);

      index++;

      if (ARRAY_LENGTH <= index) {
        index = 0;

        if (flag) {
          flag = 0;
          bufferToWrite = 1;
          Serial.println(millis());
        }
        else {
          flag = 1;
          bufferToWrite = 0;
          Serial.println(millis());
        }
        xSemaphoreGive(writeSem);
      }
    }
  }
}

void writeBufferTask(void * parameter) {
  int flag = 0;
  int index;
  index = 0;


  for (;;) {
    if ( xSemaphoreTake(writeSem, (TickType_t)1000)  == pdTRUE ) { // time for sampling ?

      if (bufferToWrite) {
        // wr B
      }
      else {
        // wr A

      }
    }
  }
}


// SD FUNCTIONS BELOW

//void readFile(fs::FS &fs, const char * path) {
//  Serial.printf("Reading file: %s\n", path);
//
//  File file = fs.open(path);
//  if (!file) {
//    Serial.println("Failed to open file for reading");
//    return;
//  }
//
//  Serial.print("Read from file: \n");
//  while (file.available()) {
//    Serial.write(file.read());
//  }
//  file.close();
//}
//
//void writeFile(fs::FS &fs, const char * path, const char * message) {
//  Serial.printf("Writing file: %s\n", path);
//
//  File file = fs.open(path, FILE_WRITE);
//  if (!file) {
//    Serial.println("Failed to open file for writing");
//    return;
//  }
//  if (file.print(message)) {
//    Serial.println("File written");
//  } else {
//    Serial.println("Write failed");
//  }
//  file.close();
//}
//
//void appendFile(fs::FS &fs, const char * path, const char * message) {
//  Serial.printf("Appending to file: %s\n", path);
//
//  File file = fs.open(path, FILE_APPEND);
//  if (!file) {
//    Serial.println("Failed to open file for appending");
//    return;
//  }
//  if (file.print(message)) {
//    Serial.println("Message appended");
//  } else {
//    Serial.println("Append failed");
//  }
//  file.close();
//}
//
//void deleteFile(fs::FS &fs, const char * path) {
//  Serial.printf("\nDeleting file: %s\n", path);
//  if (fs.remove(path)) {
//    Serial.println("File deleted");
//  } else {
//    Serial.println("Delete failed");
//  }
//}
//
//void write_array_to_File(fs::FS &fs, const char * path, int32_t * mydata, int my_data_length) {
//  File file = fs.open(path, FILE_APPEND);
//  if (!file) {
//    Serial.println("- failed to open file for writing");
//  }
//  else
//  {
//    //Serial.println("Array appended to file");
//    for (int i = 0; i < my_data_length; i++)
//    {
//      file.printf("%d\t", mydata[i]);
//    }
//    file.close();
//  }
//}
