// https://www.freertos.org/a00116.html
/*
   JDN
   queues  - FreeRTOS
*/

#define NRQ_ELM 10

struct myMsgTp {
  char ID;
  char aByte;
  boolean ledON;
};

QueueHandle_t Q1, Q2;

// QueueHandle_t Q1, Q2;
// <queueRef> = xQueueCreate( <nr elements>, sizeof( <msg> ) )

// xQueueReceive( <queue>,  &(<msg>), ( TickType_t ) <timeout> / portTICK_PERIOD_MS)
// xQueueSend(Q2, (void *)&mmm, <timeout>/ portTICK_PERIOD_MS)

//  xTaskCreatePinnedToCore(<function>, "<name>", <staksize>, <parameter / NULL>, <priority: 0:highest>, NULL, 0);

void t1(void *p)
{
  struct myMsgTp myElm;
  while (1) {

    if (pdTRUE == xQueueReceive(Q2, (void *) & (myElm), ( TickType_t ) (200 / portTICK_PERIOD_MS)) ) {

      Serial.println( myElm.aByte);

      while ( pdTRUE != xQueueSend(Q1, (void *)&myElm, 100 / portTICK_PERIOD_MS)) {}
    }
    else {
        Serial.println("timeout paa receive i task t1");
    }

    vTaskDelay(500 /  portTICK_PERIOD_MS);
  }
}

void t2(void *p)
{
  struct myMsgTp myElm; // en pointer hertil er af type (struct myMsgTp *)
  while (1) {
    while (pdTRUE != xQueueReceive(Q1, (void *) & (myElm), ( TickType_t ) (200 / portTICK_PERIOD_MS)) ) {}
    vTaskDelay(1000 /  portTICK_PERIOD_MS);   
    while ( pdTRUE != xQueueSend(Q2, (void *)&myElm, 100 / portTICK_PERIOD_MS)) {}
  }
  
}

void setup() {
  struct myMsgTp tmp;
  Serial.begin(115200); vTaskDelay(1000);

  Q1 = xQueueCreate(NRQ_ELM, sizeof(struct myMsgTp ) );
  Q2 = xQueueCreate(NRQ_ELM, sizeof(struct myMsgTp ) );
  tmp.aByte =  'a';

  for (int i = 0 ; i < NRQ_ELM / 2 ; i++) {
    xQueueSend(Q2, (void *)&tmp, 100 / portTICK_PERIOD_MS);
    tmp.aByte++;
  }

  xTaskCreatePinnedToCore(t1, "t1", 2000, NULL, 2, NULL, 0);
  xTaskCreatePinnedToCore(t2, "t2", 2000, NULL, 2 , NULL, 0);
  vTaskDelete(NULL);
}

void loop() {}
