#define CONFIG_FREERTOS_HZ 1000

void t1( void * pvParameters )
{
  TickType_t xLastWakeTime, previousWakeTime;

  const TickType_t xPeriodeTime = 123;

  int i = 0;

  // Initialise the xLastWakeTime
  xLastWakeTime = xTaskGetTickCount();  // mimiq last time e did wake

  while (1)  //for ( ;; )
  {
    // Sleep until time is  xLastWakeTime. Wake and increment sleeptime with xPeriodeTime
    //.. for next loop delay
    previousWakeTime = xLastWakeTime;
    vTaskDelayUntil( &xLastWakeTime, xPeriodeTime );  // vent indtil

    //lets see if its stable them we shall see 123 in printing
    
    Serial.print(xLastWakeTime - previousWakeTime); Serial.print(" ");
    Serial.println(i);
    i++;
    // Perform action here. sample ekg osv
  }
}


void setup()
{
  Serial.begin(115200);
  delay(3000);

  disableLoopWDT();
  xTaskCreatePinnedToCore(t1, "t1", 10000, NULL,  3, NULL, 0);
  /*
                                         ^------  handle to task code
                                     ^---------- priority 0(lowest) to  (configMAX_PRIORITIES-1)
                               ^---------------- pointer to parameter to be used as pParm in task
                          ^--------------------- amount of stak to be allocated
                   ^--------------------------- name
              ^---------------------------------- function to be used as code for task
  */
  vTaskDelete(NULL);
}

void loop()
{
}


/*
    const TickType_t xDelay = 500 / portTICK_PERIOD_MS;

     for( ;; )
     {
          vToggleLED();
         vTaskDelay( xDelay );
*/
