/*  JDN
 * Kritiske resourcer skal beskyttes
 * Feks er der jo naturligt kun een ad gangen der
 * 
 * I dette eksempel beskytter vi den serielle port
 * 
 * All bruger funktionen tID og det er kun i tID der er udskrift
 * saa derfor er det kun noedvendig med plankevaerk her(fence)
 * De ekstra {} er kun for at faa en visuel indrykning
 * 
 * Saa. 
 * 1. erklaer et plankevaerk og aabn laagen (= portMUX_INITIALIZER_UNLOCKED)
 * 2. Gaa ind , evt vent i koe   vTaskEnterCritical(&fence);
 * 3. print
 * 4. gaa ud igen vTaskExitCritical(&fence);
 */

portMUX_TYPE fence = portMUX_INITIALIZER_UNLOCKED;

void tID(int whoAreYou)
{
  // protect Serial port by setting a fence around
  vTaskEnterCritical(&fence);
  {
    Serial.print( millis());
    Serial.print(whoAreYou);
    while (whoAreYou--) Serial.print("  "); // lav indhoek
    Serial.print(whoAreYou);
    Serial.print(" core and prio ");
    Serial.print(xPortGetCoreID());
    Serial.print(" ");
    Serial.println(uxTaskPriorityGet(NULL));
  }
  vTaskExitCritical(&fence);
}


void task0 (void *pParm)
{
  while (1) {
    tID(0);
    vTaskDelay(100);
  }
}
void task1 (void *pParm)
{
  while (1) {
    tID(1);
    vTaskDelay(200);
  }
}


void task2 (void *pParm)
{
  while (1) {
    tID(2);
    vTaskDelay(600);
  }
}



void setup() {
  Serial.begin(115200);
  delay(1000);

  vTaskDelay(1000);

  disableCore0WDT();

  xTaskCreatePinnedToCore(task0, "t0", 2000, NULL,  2, NULL, 0);
  xTaskCreatePinnedToCore(task1, "t1", 2000, NULL, 2, NULL, 0);
  xTaskCreatePinnedToCore(task2, "t2", 2000, NULL, 2, NULL, 0);
  /*                                                        ^--  ´core (0or 1 on esp32)
                                                        ^------  handle to task code
                                                    ^---------- priority 0(lowest) to  (configMAX_PRIORITIES-1)
                                              ^---------------- pointer to parameter to be used as pParm in task
                                         ^--------------------- amoont of stak to be allocated
                                   ^--------------------------- name
                            ^---------------------------------- function to be used as code for task
  */
  vTaskDelete(NULL);
}

void loop() {

}
