/*
   JDN
   watchdog
   if you dont feed the dog you will reboot within <watchdog timeout> time [sec]

      https://docs.espressif.com/projects/esp-idf/en/latest/esp32/api-reference/system/wdts.html
      https://iotassistant.io/esp32/enable-hardware-watchdog-timer-esp32-arduino-ide/
*/
#include <esp_task_wdt.h>
void task1 (void *pParm)
{

  while (1) {
      vTaskDelay(1); // if you comment out vTAskDelay watchtimer will reboot 
                     // because you dont tell FreeRTOS you are alive
                     // or disable watchdog on Core0   disableCore0WDT();                          
  }
}

void setup() {
  Serial.begin(115200);
  delay(1000);

  // change timeout for watchdog esp_task_wdt_init(1, true); // <wd timeout in seconds>,<panic true/false>min 1 sec
  
  xTaskCreatePinnedToCore(task1, "t0", 2000, NULL,  2, NULL, 0);

  vTaskDelete(NULL); // terminate myself

}

void loop() {}
// esp_task_wdt_init(3, true); // https://iotassistant.io/esp32/enable-hardware-watchdog-timer-esp32-arduino-ide/

//disableCore0WDT();
//disableCore1WDT();
//disableLoopWDT();
//enableCore0WDT();
//enableCore1WDT();
//enableLoopWDT();

/*
 * https://docs.espressif.com/projects/esp-idf/en/latest/esp32/api-reference/system/wdts.html
 * esp_err_t esp_task_wdt_add(TaskHandle_t handle) - Subscribe a task to the Task Watchdog Timer (TWDT) 
 * 
 * esp_err_t esp_task_wdt_reset(void)              - Reset the Task Watchdog Timer (TWDT) on behalf of the currently running task. 
 * esp_err_t esp_task_wdt_delete(TaskHandle_t handle) - Unsubscribes a task from the Task Watchdog Timer (TWDT) 
 * esp_err_t esp_task_wdt_status(TaskHandle_t handle) Query whether a task is subscribed to the Task Watchdog Timer (TWDT)
 * 
 */ 
