#include <Arduino_FreeRTOS.h>
#include <semphr.h>
//#define CONFIG_FREERTOS_HZ 1000


SemaphoreHandle_t xSerialSemaphore;

struct comT {
  SemaphoreHandle_t mutSem;
  // k_t * mutSem;
  int memSize;
  void *pMem;
};

// struct comT *buf = malloc ( sizeof(struct comT));

// buf->mutSem     (*buf).mutSem
// buf->memSize =4;     (*buf).memSize = 4;

struct comT * crtMem(int s)
{
  struct comT *pB;

  if (s <= 0)
    return NULL;

  pB = (struct comT *) malloc( sizeof(struct comT));
  if (pB == NULL)
    return NULL;

  pB->pMem = malloc(s);
  if (pB->pMem == NULL) {
    free(pB);
    return NULL;
  }

  pB->mutSem =  xSemaphoreCreateMutex();
  // pB->mutSem = k_crt_sem(1,4); // NBNB k_crt_sem do not work AFTER k_init
  if (pB->mutSem == NULL) {
    free(pB->pMem);
    free(pB);
    return NULL;
  }

  pB->memSize = s;

  return pB;
}

int putMem(struct comT *buf, void *mem)
{
  while  (xSemaphoreTake(buf->mutSem, (TickType_t)1000)  != pdTRUE );
   

  memcpy(buf->pMem, mem, buf->memSize);

  xSemaphoreGive(buf->mutSem);
  
  return 0;  //ok
  
}

int getMem(struct comT *buf, void *mem)
{
  while  (xSemaphoreTake(buf->mutSem, (TickType_t)1000)  != pdTRUE );



  memcpy(mem, buf->pMem,  buf->memSize);
  xSemaphoreGive(buf->mutSem);
  return 0;  //ok
}

// -------------------------------


struct comT *myMem, *andenBuf;

void t1( void * parameter )
{
  char mem[10];
  for (;;)
  {
    Serial.print("12345678901234567890\n");

    putMem(myMem, (void *)"hellomann");  // \ < 00 bq text string is teminated by 0x00

    vTaskDelay(300 / portTICK_PERIOD_MS);
  }
}

void t2( void * parameter )
{
  char mem[10];
  for (;;)
  {
    getMem(myMem, (void *)mem);
    Serial.println(mem);
    vTaskDelay(100 / portTICK_PERIOD_MS);
  }
}

void t3( void * parameter )
{
  for (;;)
  {
    Serial.print("ABCDEFGHIJKLMNOPQRST\n");
    vTaskDelay(500 / portTICK_PERIOD_MS);
  }
}

void setup()
{
  if ( xSerialSemaphore == NULL )  // Check to confirm that the Serial Semaphore has not already been created.
  {
    xSerialSemaphore = xSemaphoreCreateMutex();  // Create a mutex semaphore we will use to manage the Serial Port
    if ( ( xSerialSemaphore ) != NULL )
      xSemaphoreGive( ( xSerialSemaphore ) );  // Make the Serial Port available for use, by "Giving" the Semaphore.
  }

  Serial.begin(115200);
  delay(3000);
  Serial.println(configMAX_PRIORITIES);
  myMem = crtMem(10);
  andenBuf = crtMem(14);
  if (myMem == NULL) {
    Serial.println("could not crt");

  }
  Serial.println("crt tast now");
  xTaskCreate(t1, "t1", 100, NULL,  1, NULL); // NB 100 == 200 bytes ! bq word size is 2
  xTaskCreate(t2, "t1", 100, NULL,  1, NULL);
  xTaskCreate(t3, "t1", 100, NULL,  1, NULL);

}

void loop()
{
    //   must be empty in arduino world
}
