#include <esp_task_wdt.h>
void t1(void *p)
{
  int i = 0;
  esp_task_wdt_init(3,true); // https://iotassistant.io/esp32/enable-hardware-watchdog-timer-esp32-arduino-ide/
  // https://docs.espressif.com/projects/esp-idf/en/latest/esp32/api-reference/system/wdts.html
   
  esp_task_wdt_add(NULL);
  while (1) {
    Serial.println(i++);
    esp_task_wdt_reset();
  }
}

void setup() {
  Serial.begin(115200);
  delay(2000);
  disableCore0WDT();
  xTaskCreate(t1, "t1", 10000, NULL,  1, NULL);
}

void loop() {

}


#ifdef NEVERJDN
https://docs.espressif.com/projects/esp-idf/en/latest/esp32/api-reference/system/wdts.html



https://github.com/espressif/arduino-esp32/blob/master/cores/esp32/esp32-hal.h#L76-L91

#if CONFIG_AUTOSTART_ARDUINO
//enable/disable WDT for Arduino's setup and loop functions
void enableLoopWDT();
void disableLoopWDT();
//feed WDT for the loop task
void feedLoopWDT();
#endif

//enable/disable WDT for the IDLE task on Core 0 (SYSTEM)
void enableCore0WDT();
void disableCore0WDT();
#ifndef CONFIG_FREERTOS_UNICORE
//enable/disable WDT for the IDLE task on Core 1 (Arduino)
void enableCore1WDT();
void disableCore1WDT();
#endif

#endif
